/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven;

import de.softwareforge.testing.maven.MavenArtifactLoader;
import de.softwareforge.testing.maven.VersionStrategy;
import de.softwareforge.testing.maven.org.eclipse.aether.version.$Version;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class MavenVersionMatchBuilder {
    private final MavenArtifactLoader loader;
    private final String groupId;
    private final String artifactId;
    private VersionStrategy versionStrategy = VersionStrategy.partialMatch("");
    private String extension = "jar";
    private boolean includeSnapshots = true;

    MavenVersionMatchBuilder(MavenArtifactLoader loader, String groupId, String artifactId) {
        this.loader = loader;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public MavenVersionMatchBuilder partialMatch(String partial) {
        this.versionStrategy = VersionStrategy.partialMatch(partial);
        return this;
    }

    public MavenVersionMatchBuilder exactMatch(String partial) {
        this.versionStrategy = VersionStrategy.exactMatch(partial);
        return this;
    }

    public MavenVersionMatchBuilder semVerMajor(int major) {
        this.versionStrategy = VersionStrategy.semVerMatchMajor(major);
        return this;
    }

    public MavenVersionMatchBuilder semVerMinor(int major, int minor) {
        this.versionStrategy = VersionStrategy.semVerMatchMinor(major, minor);
        return this;
    }

    public MavenVersionMatchBuilder extension(String extension) {
        this.extension = Objects.requireNonNull(extension, "extension is null");
        return this;
    }

    public MavenVersionMatchBuilder includeSnapshots(boolean includeSnapshots) {
        this.includeSnapshots = includeSnapshots;
        return this;
    }

    String groupId() {
        return this.groupId;
    }

    String artifactId() {
        return this.artifactId;
    }

    VersionStrategy versionStrategy() {
        return this.versionStrategy;
    }

    String extension() {
        return this.extension;
    }

    boolean includeSnapshots() {
        return this.includeSnapshots;
    }

    public LinkedList<String> findAll() throws IOException {
        return this.loader.findAllVersions(this).stream().map($Version::toString).collect(Collectors.toCollection(LinkedList::new));
    }

    public Optional<String> findBestMatch() throws IOException {
        LinkedList<String> versions = this.findAll();
        return versions.isEmpty() ? Optional.empty() : Optional.of(versions.getLast());
    }
}

