/*
 * Decompiled with CFR 0.152.
 */
package jflex.maven.plugin.jflex;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import jflex.maven.plugin.jflex.SpecInfo;

class LexSimpleAnalyzerUtils {
    static final String DEFAULT_NAME = "Yylex";
    private static final Pattern INCLUDE_DIRECTIVE_MATCHER = Pattern.compile("^\\s*%include\\s+(.+)");
    private static final int INCLUDE_DIRECTIVE_ARG_OFFSET = 1;

    static SpecInfo guessSpecInfo(File lexFile) throws IOException {
        BufferedReader lexFileReader = Files.newReader((File)lexFile, (Charset)StandardCharsets.UTF_8);
        return LexSimpleAnalyzerUtils.guessSpecInfo(lexFileReader, lexFile);
    }

    static SpecInfo guessSpecInfo(Reader lexFileReader, File lexFile) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(lexFileReader);){
            String line;
            String className = null;
            String packageName = null;
            while ((className == null || packageName == null) && (line = reader.readLine()) != null) {
                if (packageName == null) {
                    packageName = LexSimpleAnalyzerUtils.guessPackage(line);
                }
                if (className != null) continue;
                className = LexSimpleAnalyzerUtils.guessClass(line);
            }
            if (className == null) {
                className = DEFAULT_NAME;
            }
            SpecInfo specInfo = new SpecInfo(className, packageName, LexSimpleAnalyzerUtils.guessIncludes(lexFile));
            return specInfo;
        }
    }

    private static Set<File> guessIncludes(File file) {
        return LexSimpleAnalyzerUtils.nestedIncludes(new HashSet<File>(), file);
    }

    private static Set<File> nestedIncludes(Set<File> seen, File file) {
        HashSet<File> includedFiles = new HashSet<File>();
        HashSet<File> newSeen = new HashSet<File>(seen);
        try {
            BufferedReader reader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);
            Set<File> newFiles = LexSimpleAnalyzerUtils.mapFiles(LexSimpleAnalyzerUtils.parseIncludes(reader), file.getParentFile());
            newFiles.removeAll(seen);
            newSeen.addAll(newFiles);
            includedFiles.addAll(newFiles);
            Set nested = newFiles.stream().flatMap(f -> LexSimpleAnalyzerUtils.nestedIncludes(newSeen, f).stream()).collect(Collectors.toSet());
            includedFiles.addAll(nested);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return includedFiles;
    }

    static Set<File> mapFiles(Set<String> set, File parent) {
        return set.stream().map(s -> new File(parent, (String)s)).collect(Collectors.toSet());
    }

    static Set<String> parseIncludes(Reader fileReader) throws IOException {
        HashSet<String> includedFiles = new HashSet<String>();
        try (LineNumberReader reader = new LineNumberReader(fileReader);){
            String line = reader.readLine();
            while (line != null) {
                String includedFile = LexSimpleAnalyzerUtils.guessIncluded(line);
                if (includedFile != null) {
                    includedFiles.add(includedFile);
                }
                line = reader.readLine();
            }
        }
        return includedFiles;
    }

    @Nullable
    private static String guessClass(String line) {
        int index = line.indexOf("%class");
        if (index > -1) {
            return line.substring(index += "%class".length()).trim();
        }
        return null;
    }

    @Nullable
    private static String guessPackage(String line) {
        int end;
        int index = line.trim().indexOf("package");
        if (index == 0 && (end = line.indexOf(59, index += "package".length())) >= index) {
            return line.substring(index, end).trim();
        }
        return null;
    }

    @Nullable
    private static String guessIncluded(String line) {
        Matcher matcher = INCLUDE_DIRECTIVE_MATCHER.matcher(line);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    private LexSimpleAnalyzerUtils() {
    }
}

