package de.flapdoodle.reverse.transitions;

import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Derive}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDerive.builder()}.
 */
@Generated(from = "Derive", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDerive<S, D> extends Derive<S, D> {
  private final StateID<S> source;
  private final StateID<D> destination;
  private final Function<S, State<D>> action;
  private final String transitionLabel;

  private ImmutableDerive(ImmutableDerive.Builder<S, D> builder) {
    this.source = builder.source;
    this.destination = builder.destination;
    this.action = builder.action;
    this.transitionLabel = builder.transitionLabel != null
        ? builder.transitionLabel
        : Objects.requireNonNull(super.transitionLabel(), "transitionLabel");
  }

  private ImmutableDerive(
      StateID<S> source,
      StateID<D> destination,
      Function<S, State<D>> action,
      String transitionLabel) {
    this.source = source;
    this.destination = destination;
    this.action = action;
    this.transitionLabel = transitionLabel;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public StateID<S> source() {
    return source;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<D> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  protected Function<S, State<D>> action() {
    return action;
  }

  /**
   * @return The value of the {@code transitionLabel} attribute
   */
  @Override
  public String transitionLabel() {
    return transitionLabel;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Derive#source() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDerive<S, D> withSource(StateID<S> value) {
    if (this.source == value) return this;
    StateID<S> newValue = Objects.requireNonNull(value, "source");
    return new ImmutableDerive<>(newValue, this.destination, this.action, this.transitionLabel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Derive#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDerive<S, D> withDestination(StateID<D> value) {
    if (this.destination == value) return this;
    StateID<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableDerive<>(this.source, newValue, this.action, this.transitionLabel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Derive#action() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDerive<S, D> withAction(Function<S, State<D>> value) {
    if (this.action == value) return this;
    Function<S, State<D>> newValue = Objects.requireNonNull(value, "action");
    return new ImmutableDerive<>(this.source, this.destination, newValue, this.transitionLabel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Derive#transitionLabel() transitionLabel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transitionLabel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDerive<S, D> withTransitionLabel(String value) {
    String newValue = Objects.requireNonNull(value, "transitionLabel");
    if (this.transitionLabel.equals(newValue)) return this;
    return new ImmutableDerive<>(this.source, this.destination, this.action, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDerive} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDerive<?, ?>
        && equalTo(0, (ImmutableDerive<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableDerive<?, ?> another) {
    return source.equals(another.source)
        && destination.equals(another.destination)
        && action.equals(another.action)
        && transitionLabel.equals(another.transitionLabel);
  }

  /**
   * Computes a hash code from attributes: {@code source}, {@code destination}, {@code action}, {@code transitionLabel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + source.hashCode();
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + action.hashCode();
    h += (h << 5) + transitionLabel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Derive} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Derive{"
        + "source=" + source
        + ", destination=" + destination
        + ", action=" + action
        + ", transitionLabel=" + transitionLabel
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long SOURCES_LAZY_INIT_BIT = 0x1L;

  private transient Set<StateID<?>> sources;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Derive#sources() sources} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code sources} attribute
   */
  @Override
  public Set<StateID<?>> sources() {
    if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
          this.sources = Objects.requireNonNull(super.sources(), "sources");
          lazyInitBitmap |= SOURCES_LAZY_INIT_BIT;
        }
      }
    }
    return sources;
  }

  /**
   * Creates an immutable copy of a {@link Derive} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <S> generic parameter S
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable Derive instance
   */
  public static <S, D> ImmutableDerive<S, D> copyOf(Derive<S, D> instance) {
    if (instance instanceof ImmutableDerive<?, ?>) {
      return (ImmutableDerive<S, D>) instance;
    }
    return ImmutableDerive.<S, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDerive ImmutableDerive}.
   * <pre>
   * ImmutableDerive.&amp;lt;S, D&amp;gt;builder()
   *    .source(de.flapdoodle.reverse.StateID&amp;lt;S&amp;gt;) // required {@link Derive#source() source}
   *    .destination(de.flapdoodle.reverse.StateID&amp;lt;D&amp;gt;) // required {@link Derive#destination() destination}
   *    .action(function.Function&amp;lt;S, de.flapdoodle.reverse.State&amp;lt;D&amp;gt;&amp;gt;) // required {@link Derive#action() action}
   *    .transitionLabel(String) // optional {@link Derive#transitionLabel() transitionLabel}
   *    .build();
   * </pre>
   * @param <S> generic parameter S
   * @param <D> generic parameter D
   * @return A new ImmutableDerive builder
   */
  public static <S, D> ImmutableDerive.Builder<S, D> builder() {
    return new ImmutableDerive.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableDerive ImmutableDerive}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Derive", generator = "Immutables")
  public static final class Builder<S, D> {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_DESTINATION = 0x2L;
    private static final long INIT_BIT_ACTION = 0x4L;
    private long initBits = 0x7L;

    private StateID<S> source;
    private StateID<D> destination;
    private Function<S, State<D>> action;
    private String transitionLabel;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.reverse.transitions.Derive} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> from(Derive<S, D> instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.reverse.naming.HasLabel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> from(HasLabel instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof Derive<?, ?>) {
        Derive<S, D> instance = (Derive<S, D>) object;
        destination(instance.destination());
        action(instance.action());
        source(instance.source());
        if ((bits & 0x1L) == 0) {
          transitionLabel(instance.transitionLabel());
          bits |= 0x1L;
        }
      }
      if (object instanceof HasLabel) {
        HasLabel instance = (HasLabel) object;
        if ((bits & 0x1L) == 0) {
          transitionLabel(instance.transitionLabel());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Derive#source() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> source(StateID<S> source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link Derive#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> destination(StateID<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Derive#action() action} attribute.
     * @param action The value for action 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> action(Function<S, State<D>> action) {
      this.action = Objects.requireNonNull(action, "action");
      initBits &= ~INIT_BIT_ACTION;
      return this;
    }

    /**
     * Initializes the value for the {@link Derive#transitionLabel() transitionLabel} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Derive#transitionLabel() transitionLabel}.</em>
     * @param transitionLabel The value for transitionLabel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> transitionLabel(String transitionLabel) {
      this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDerive ImmutableDerive}.
     * @return An immutable instance of Derive
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDerive<S, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDerive<S, D>(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_ACTION) != 0) attributes.add("action");
      return "Cannot build Derive, some of required attributes are not set " + attributes;
    }
  }
}
