package de.flapdoodle.reverse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StateMapping}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStateMapping.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStateMapping.of()}.
 */
@Generated(from = "StateMapping", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableStateMapping<T> extends StateMapping<T> {
  private final StateID<T> source;
  private final StateID<T> destination;

  private ImmutableStateMapping(StateID<T> source, StateID<T> destination) {
    this.source = Objects.requireNonNull(source, "source");
    this.destination = Objects.requireNonNull(destination, "destination");
  }

  private ImmutableStateMapping(
      ImmutableStateMapping<T> original,
      StateID<T> source,
      StateID<T> destination) {
    this.source = source;
    this.destination = destination;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public StateID<T> source() {
    return source;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<T> destination() {
    return destination;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StateMapping#source() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStateMapping<T> withSource(StateID<T> value) {
    if (this.source == value) return this;
    StateID<T> newValue = Objects.requireNonNull(value, "source");
    return new ImmutableStateMapping<>(this, newValue, this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StateMapping#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStateMapping<T> withDestination(StateID<T> value) {
    if (this.destination == value) return this;
    StateID<T> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableStateMapping<>(this, this.source, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStateMapping} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStateMapping<?>
        && equalTo(0, (ImmutableStateMapping<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableStateMapping<?> another) {
    return source.equals(another.source)
        && destination.equals(another.destination);
  }

  /**
   * Computes a hash code from attributes: {@code source}, {@code destination}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + source.hashCode();
    h += (h << 5) + destination.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StateMapping} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StateMapping{"
        + "source=" + source
        + ", destination=" + destination
        + "}";
  }

  /**
   * Construct a new immutable {@code StateMapping} instance.
 * @param <T> generic parameter T
   * @param source The value for the {@code source} attribute
   * @param destination The value for the {@code destination} attribute
   * @return An immutable StateMapping instance
   */
  public static <T> ImmutableStateMapping<T> of(StateID<T> source, StateID<T> destination) {
    return new ImmutableStateMapping<>(source, destination);
  }

  /**
   * Creates an immutable copy of a {@link StateMapping} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable StateMapping instance
   */
  public static <T> ImmutableStateMapping<T> copyOf(StateMapping<T> instance) {
    if (instance instanceof ImmutableStateMapping<?>) {
      return (ImmutableStateMapping<T>) instance;
    }
    return ImmutableStateMapping.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStateMapping ImmutableStateMapping}.
   * <pre>
   * ImmutableStateMapping.&amp;lt;T&amp;gt;builder()
   *    .source(de.flapdoodle.reverse.StateID&amp;lt;T&amp;gt;) // required {@link StateMapping#source() source}
   *    .destination(de.flapdoodle.reverse.StateID&amp;lt;T&amp;gt;) // required {@link StateMapping#destination() destination}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableStateMapping builder
   */
  public static <T> ImmutableStateMapping.Builder<T> builder() {
    return new ImmutableStateMapping.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableStateMapping ImmutableStateMapping}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StateMapping", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_DESTINATION = 0x2L;
    private long initBits = 0x3L;

    private StateID<T> source;
    private StateID<T> destination;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StateMapping} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(StateMapping<T> instance) {
      Objects.requireNonNull(instance, "instance");
      source(instance.source());
      destination(instance.destination());
      return this;
    }

    /**
     * Initializes the value for the {@link StateMapping#source() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> source(StateID<T> source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link StateMapping#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> destination(StateID<T> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStateMapping ImmutableStateMapping}.
     * @return An immutable instance of StateMapping
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStateMapping<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStateMapping<>(null, source, destination);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      return "Cannot build StateMapping, some of required attributes are not set " + attributes;
    }
  }
}
