package de.flapdoodle.types;

import de.flapdoodle.reflection.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Pair.PairTypeInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePairTypeInfo.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePairTypeInfo.of()}.
 */
@Generated(from = "Pair.PairTypeInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutablePairTypeInfo<FIRST, SECOND>
    extends Pair.PairTypeInfo<FIRST, SECOND> {
  private final TypeInfo<FIRST> first;
  private final TypeInfo<SECOND> second;

  private ImmutablePairTypeInfo(TypeInfo<FIRST> first, TypeInfo<SECOND> second) {
    this.first = Objects.requireNonNull(first, "first");
    this.second = Objects.requireNonNull(second, "second");
  }

  private ImmutablePairTypeInfo(
      ImmutablePairTypeInfo<FIRST, SECOND> original,
      TypeInfo<FIRST> first,
      TypeInfo<SECOND> second) {
    this.first = first;
    this.second = second;
  }

  /**
   * @return The value of the {@code first} attribute
   */
  @Override
  public TypeInfo<FIRST> first() {
    return first;
  }

  /**
   * @return The value of the {@code second} attribute
   */
  @Override
  public TypeInfo<SECOND> second() {
    return second;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pair.PairTypeInfo#first() first} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for first
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePairTypeInfo<FIRST, SECOND> withFirst(TypeInfo<FIRST> value) {
    if (this.first == value) return this;
    TypeInfo<FIRST> newValue = Objects.requireNonNull(value, "first");
    return new ImmutablePairTypeInfo<>(this, newValue, this.second);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pair.PairTypeInfo#second() second} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for second
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePairTypeInfo<FIRST, SECOND> withSecond(TypeInfo<SECOND> value) {
    if (this.second == value) return this;
    TypeInfo<SECOND> newValue = Objects.requireNonNull(value, "second");
    return new ImmutablePairTypeInfo<>(this, this.first, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePairTypeInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePairTypeInfo<?, ?>
        && equalTo(0, (ImmutablePairTypeInfo<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutablePairTypeInfo<?, ?> another) {
    return first.equals(another.first)
        && second.equals(another.second);
  }

  /**
   * Computes a hash code from attributes: {@code first}, {@code second}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + first.hashCode();
    h += (h << 5) + second.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PairTypeInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PairTypeInfo{"
        + "first=" + first
        + ", second=" + second
        + "}";
  }

  /**
   * Construct a new immutable {@code PairTypeInfo} instance.
 * @param <FIRST> generic parameter FIRST
 * @param <SECOND> generic parameter SECOND
   * @param first The value for the {@code first} attribute
   * @param second The value for the {@code second} attribute
   * @return An immutable PairTypeInfo instance
   */
  public static <FIRST, SECOND> ImmutablePairTypeInfo<FIRST, SECOND> of(TypeInfo<FIRST> first, TypeInfo<SECOND> second) {
    return new ImmutablePairTypeInfo<>(first, second);
  }

  /**
   * Creates an immutable copy of a {@link Pair.PairTypeInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <FIRST> generic parameter FIRST
   * @param <SECOND> generic parameter SECOND
   * @param instance The instance to copy
   * @return A copied immutable PairTypeInfo instance
   */
  public static <FIRST, SECOND> ImmutablePairTypeInfo<FIRST, SECOND> copyOf(Pair.PairTypeInfo<FIRST, SECOND> instance) {
    if (instance instanceof ImmutablePairTypeInfo<?, ?>) {
      return (ImmutablePairTypeInfo<FIRST, SECOND>) instance;
    }
    return ImmutablePairTypeInfo.<FIRST, SECOND>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePairTypeInfo ImmutablePairTypeInfo}.
   * <pre>
   * ImmutablePairTypeInfo.&amp;lt;FIRST, SECOND&amp;gt;builder()
   *    .first(de.flapdoodle.reflection.TypeInfo&amp;lt;FIRST&amp;gt;) // required {@link Pair.PairTypeInfo#first() first}
   *    .second(de.flapdoodle.reflection.TypeInfo&amp;lt;SECOND&amp;gt;) // required {@link Pair.PairTypeInfo#second() second}
   *    .build();
   * </pre>
   * @param <FIRST> generic parameter FIRST
   * @param <SECOND> generic parameter SECOND
   * @return A new ImmutablePairTypeInfo builder
   */
  public static <FIRST, SECOND> ImmutablePairTypeInfo.Builder<FIRST, SECOND> builder() {
    return new ImmutablePairTypeInfo.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutablePairTypeInfo ImmutablePairTypeInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Pair.PairTypeInfo", generator = "Immutables")
  public static final class Builder<FIRST, SECOND> {
    private static final long INIT_BIT_FIRST = 0x1L;
    private static final long INIT_BIT_SECOND = 0x2L;
    private long initBits = 0x3L;

    private TypeInfo<FIRST> first;
    private TypeInfo<SECOND> second;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PairTypeInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<FIRST, SECOND> from(Pair.PairTypeInfo<FIRST, SECOND> instance) {
      Objects.requireNonNull(instance, "instance");
      first(instance.first());
      second(instance.second());
      return this;
    }

    /**
     * Initializes the value for the {@link Pair.PairTypeInfo#first() first} attribute.
     * @param first The value for first 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<FIRST, SECOND> first(TypeInfo<FIRST> first) {
      this.first = Objects.requireNonNull(first, "first");
      initBits &= ~INIT_BIT_FIRST;
      return this;
    }

    /**
     * Initializes the value for the {@link Pair.PairTypeInfo#second() second} attribute.
     * @param second The value for second 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<FIRST, SECOND> second(TypeInfo<SECOND> second) {
      this.second = Objects.requireNonNull(second, "second");
      initBits &= ~INIT_BIT_SECOND;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePairTypeInfo ImmutablePairTypeInfo}.
     * @return An immutable instance of PairTypeInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePairTypeInfo<FIRST, SECOND> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePairTypeInfo<>(null, first, second);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIRST) != 0) attributes.add("first");
      if ((initBits & INIT_BIT_SECOND) != 0) attributes.add("second");
      return "Cannot build PairTypeInfo, some of required attributes are not set " + attributes;
    }
  }
}
