/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.graph;

import de.flapdoodle.graph.ImmutableGraphAsDot;
import de.flapdoodle.graph.ImmutableSubGraph;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.jgrapht.Graph;

@Value.Immutable
public abstract class GraphAsDot<T> {
    @Builder.Parameter
    public abstract Function<T, String> nodeAsId();

    @Value.Default
    public String subGraphIdSeparator() {
        return ":";
    }

    @Value.Default
    public Function<T, String> nodeAsLabel() {
        return this.nodeAsId();
    }

    @Value.Default
    public BiFunction<T, T, Map<String, String>> edgeAttributes() {
        return (a, b) -> Collections.emptyMap();
    }

    @Value.Default
    public Function<T, Map<String, String>> nodeAttributes() {
        return a -> Collections.emptyMap();
    }

    @Value.Default
    public Function<T, Optional<SubGraph<T>>> subGraph() {
        return a -> Optional.empty();
    }

    public abstract Optional<Function<T, Comparable>> sortedBy();

    @Value.Default
    public String label() {
        return "graph";
    }

    @Value.Auxiliary
    public <E> String asDot(Graph<T, E> graph) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph \"").append(this.label()).append("\" {\n").append("\trankdir=LR;\n").append("\n");
        Context<T> context = new Context<T>(this, sb);
        this.render(context.render(graph, 1));
        sb.append("}\n");
        return sb.toString();
    }

    private <E> void render(Context.Render<E> context) {
        this.renderNodes(context);
        context.newLine();
        this.renderEdges(context);
    }

    private <E> void renderNodes(Context.Render<E> context) {
        context.forEachVertex(v -> {
            Optional<Context.Render<?>> subContext = context.subGraph(v);
            if (subContext.isPresent()) {
                context.line("subgraph cluster_" + ((Context.Render)subContext.get()).clusterId + " {");
                subContext.get().line("label = " + GraphAsDot.quote(context.context.root.nodeAsLabel().apply(v)) + ";");
                this.render(subContext.get());
                context.line("}");
            } else {
                context.renderNode(v);
            }
        });
    }

    private <E> void renderEdges(Context.Render<E> context) {
        context.forEachEdge((a, b) -> {
            if (context.isNoSubGraph(a) && context.isNoSubGraph(b)) {
                context.connection(a, b);
            } else {
                context.subGraphConnection(a, b);
            }
        });
    }

    private static String asNodeAttributes(Map<String, String> map) {
        return map.isEmpty() ? "" : "[ " + map.entrySet().stream().map(e -> (String)e.getKey() + "=" + GraphAsDot.quote((String)e.getValue())).collect(Collectors.joining(", ")) + " ]";
    }

    private static String quote(String src) {
        return "\"" + src + "\"";
    }

    public static <T> ImmutableGraphAsDot.Builder<T> builder(Function<T, String> nodeAsId) {
        return ImmutableGraphAsDot.builder(nodeAsId);
    }

    private static class MappingEdgeComparator<T, E, C extends Comparable<C>>
    implements Comparator<E> {
        private final Graph<T, E> graph;
        private final MappingComparator<T, C> comparator;

        public MappingEdgeComparator(Graph<T, E> graph, Function<T, C> asComparable) {
            this.graph = graph;
            this.comparator = new MappingComparator(asComparable);
        }

        @Override
        public int compare(E first, E second) {
            int compareFirst = this.comparator.compare(this.graph.getEdgeSource(first), this.graph.getEdgeSource(second));
            return compareFirst == 0 ? this.comparator.compare(this.graph.getEdgeTarget(first), this.graph.getEdgeTarget(second)) : compareFirst;
        }
    }

    private static class MappingComparator<T, C extends Comparable<C>>
    implements Comparator<T> {
        private final Function<T, C> mapping;

        private MappingComparator(Function<T, C> mapping) {
            this.mapping = mapping;
        }

        @Override
        public int compare(T first, T second) {
            return ((Comparable)this.mapping.apply(first)).compareTo(this.mapping.apply(second));
        }
    }

    @FunctionalInterface
    public static interface AsComparable<T, C extends Comparable<C>>
    extends Function<T, C> {
    }

    private static final class VertexInSubGraph<T> {
        private final T parent;
        private final T vertex;

        public VertexInSubGraph(T parent, T vertex) {
            this.parent = parent;
            this.vertex = vertex;
        }

        public String toString() {
            return "VertexInSubGraph{parent=" + this.parent + ", vertex=" + this.vertex + '}';
        }
    }

    private static final class Vertext2VertexInSubGraph<T> {
        private final T vertex;
        private final VertexInSubGraph<T> vertexInSubGraph;

        public Vertext2VertexInSubGraph(T vertex, VertexInSubGraph<T> vertexInSubGraph) {
            this.vertex = vertex;
            this.vertexInSubGraph = vertexInSubGraph;
        }
    }

    private static final class Vertex2SubGraph<T> {
        private final T vertext;
        private final SubGraph<T> subGraph;

        public Vertex2SubGraph(T vertext, SubGraph<T> subGraph) {
            this.vertext = vertext;
            this.subGraph = subGraph;
        }
    }

    @Value.Immutable
    public static interface SubGraph<T> {
        @Builder.Parameter
        public Graph<T, ?> graph();

        public Map<T, T> connections();

        public static <T> ImmutableSubGraph.Builder<T> of(Graph<T, ?> graph) {
            return ImmutableSubGraph.builder(graph);
        }
    }

    private static class Context<T> {
        private final GraphAsDot<T> root;
        private final StringBuilder sb;
        private final AtomicInteger clusterCounter = new AtomicInteger();

        public Context(GraphAsDot<T> root, StringBuilder sb) {
            this.root = root;
            this.sb = sb;
        }

        public <E> Render<E> render(Graph<T, E> graph, int level) {
            return new Render(this, graph, level, "");
        }

        private class Render<E> {
            private final Context<T> context;
            private final Graph<T, E> graph;
            private final int level;
            private final Map<T, VertexInSubGraph<T>> outerVertexToInnerVertexMap;
            private final int clusterId;
            private final String clusterPrefix;
            private final String indent;

            private Render(Context<T> context2, Graph<T, E> graph, int level, String clusterPrefix) {
                this.context = context2;
                this.graph = graph;
                this.level = level;
                this.clusterPrefix = clusterPrefix;
                this.clusterId = context2.clusterCounter.getAndIncrement();
                this.indent = String.join((CharSequence)"", Collections.nCopies(level, "\t"));
                List subGraphs = graph.vertexSet().stream().flatMap(v -> context2.root.subGraph().apply(v).map(Stream::of).orElse(Stream.empty()).map(sub -> new Vertex2SubGraph<Object>(v, (SubGraph<Object>)sub))).collect(Collectors.toList());
                List outerVertexToInnerVertexList = subGraphs.stream().flatMap(sub -> ((Vertex2SubGraph)sub).subGraph.connections().entrySet().stream().map(entry -> new Vertext2VertexInSubGraph<Object>(entry.getKey(), new VertexInSubGraph<Object>(((Vertex2SubGraph)sub).vertext, entry.getValue())))).collect(Collectors.toList());
                this.outerVertexToInnerVertexMap = outerVertexToInnerVertexList.stream().collect(Collectors.toMap(v -> ((Vertext2VertexInSubGraph)v).vertex, v -> ((Vertext2VertexInSubGraph)v).vertexInSubGraph));
            }

            public Optional<Render<?>> subGraph(T v) {
                Optional<SubGraph<SubGraph>> subGraph = this.context.root.subGraph().apply(v);
                return subGraph.map(sg -> this.subGraph(sg.graph(), this.clusterPrefix(v)));
            }

            private String clusterPrefix(T cluster) {
                String separator = this.context.root.subGraphIdSeparator();
                String localPrefix = this.context.root.nodeAsId().apply(cluster);
                return this.clusterPrefix.isEmpty() ? localPrefix + separator : this.clusterPrefix + localPrefix + separator;
            }

            private <X> Render<X> subGraph(Graph<T, X> subGraph, String prefix) {
                return new Render<X>(this.context, subGraph, this.level + 1, prefix);
            }

            public void newLine() {
                Context.this.sb.append("\n");
            }

            public Render<E> line(String content) {
                Context.this.sb.append(this.indent).append(content).append("\n");
                return this;
            }

            public void forEachEdge(BiConsumer<T, T> onEdge) {
                Consumer<Object> edgeConsumer = edge -> {
                    Object start = this.graph.getEdgeSource(edge);
                    Object end = this.graph.getEdgeTarget(edge);
                    onEdge.accept(start, end);
                };
                if (Context.this.root.sortedBy().isPresent()) {
                    this.graph.edgeSet().stream().sorted(new MappingEdgeComparator(this.graph, Context.this.root.sortedBy().get())).forEach(edgeConsumer);
                } else {
                    this.graph.edgeSet().forEach(edgeConsumer);
                }
            }

            public boolean isNoSubGraph(T vertex) {
                return !this.context.root.subGraph().apply(vertex).isPresent();
            }

            private Render<E> connection(T a, T b) {
                this.renderConnection(this.clusterPrefix + Context.this.root.nodeAsId().apply(a), this.clusterPrefix + Context.this.root.nodeAsId().apply(b), Context.this.root.edgeAttributes().apply(a, b), Context.this.sb);
                return this;
            }

            public void subGraphConnection(T a, T b) {
                VertexInSubGraph innerA = this.outerVertexToInnerVertexMap.get(a);
                VertexInSubGraph innerB = this.outerVertexToInnerVertexMap.get(b);
                if (innerA != null) {
                    String aId = this.clusterPrefix + Context.this.root.nodeAsId().apply(a);
                    String innerAId = this.clusterPrefix(innerA.parent) + Context.this.root.nodeAsId().apply(innerA.vertex);
                    this.renderConnection(aId, innerAId, Context.this.root.edgeAttributes().apply(a, innerA.vertex), Context.this.sb);
                }
                if (innerB != null) {
                    String innerBId = this.clusterPrefix(innerB.parent) + Context.this.root.nodeAsId().apply(innerB.vertex);
                    String bId = this.clusterPrefix + Context.this.root.nodeAsId().apply(b);
                    this.renderConnection(innerBId, bId, Context.this.root.edgeAttributes().apply(innerB.vertex, b), Context.this.sb);
                }
                if (innerA == null && innerB == null) {
                    throw new IllegalArgumentException("could not find mapping for " + a + " or " + b + " in " + this.outerVertexToInnerVertexMap);
                }
            }

            public void forEachVertex(Consumer<T> onVertex) {
                if (Context.this.root.sortedBy().isPresent()) {
                    this.graph.vertexSet().stream().sorted(new MappingComparator(Context.this.root.sortedBy().get())).forEach(onVertex);
                } else {
                    this.graph.vertexSet().forEach(onVertex);
                }
            }

            public void renderNode(T v) {
                String id = this.clusterPrefix + this.context.root.nodeAsId().apply(v);
                String label = this.context.root.nodeAsLabel().apply(v);
                Map<String, String> attributes = this.context.root.nodeAttributes().apply(v);
                this.line(GraphAsDot.quote(id) + GraphAsDot.asNodeAttributes(id.equals(label) ? attributes : this.withLabel(attributes, label)) + ";");
            }

            private Map<String, String> withLabel(Map<String, String> attributes, String label) {
                LinkedHashMap<String, String> copy = new LinkedHashMap<String, String>(attributes);
                if (!copy.containsKey("label")) {
                    copy.put("label", label);
                }
                return copy;
            }

            private void renderConnection(String a, String b, Map<String, String> edgeAttributes, StringBuilder sb) {
                sb.append(this.indent);
                sb.append(GraphAsDot.quote(a)).append(" -> ").append(GraphAsDot.quote(b)).append(GraphAsDot.asNodeAttributes(edgeAttributes)).append(";\n");
            }
        }
    }
}

