/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config;

import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.config.process.ProcessOutput;
import de.flapdoodle.embed.process.runtime.CommandLinePostProcessor;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="RuntimeConfig", generator="Immutables")
public final class ImmutableRuntimeConfig
implements RuntimeConfig {
    private final ProcessOutput processOutput;
    private final CommandLinePostProcessor commandLinePostProcessor;
    private final IArtifactStore artifactStore;
    private final boolean isDaemonProcess;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRuntimeConfig(Builder builder) {
        this.processOutput = builder.processOutput;
        this.artifactStore = builder.artifactStore;
        if (builder.commandLinePostProcessor != null) {
            this.initShim.commandLinePostProcessor(builder.commandLinePostProcessor);
        }
        if (builder.isDaemonProcessIsSet()) {
            this.initShim.isDaemonProcess(builder.isDaemonProcess);
        }
        this.commandLinePostProcessor = this.initShim.commandLinePostProcessor();
        this.isDaemonProcess = this.initShim.isDaemonProcess();
        this.initShim = null;
    }

    private ImmutableRuntimeConfig(ProcessOutput processOutput, CommandLinePostProcessor commandLinePostProcessor, IArtifactStore artifactStore, boolean isDaemonProcess) {
        this.processOutput = processOutput;
        this.commandLinePostProcessor = commandLinePostProcessor;
        this.artifactStore = artifactStore;
        this.isDaemonProcess = isDaemonProcess;
        this.initShim = null;
    }

    private CommandLinePostProcessor commandLinePostProcessorInitialize() {
        return RuntimeConfig.super.commandLinePostProcessor();
    }

    private boolean isDaemonProcessInitialize() {
        return RuntimeConfig.super.isDaemonProcess();
    }

    @Override
    public ProcessOutput processOutput() {
        return this.processOutput;
    }

    @Override
    public CommandLinePostProcessor commandLinePostProcessor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.commandLinePostProcessor() : this.commandLinePostProcessor;
    }

    @Override
    public IArtifactStore artifactStore() {
        return this.artifactStore;
    }

    @Override
    public boolean isDaemonProcess() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isDaemonProcess() : this.isDaemonProcess;
    }

    public final ImmutableRuntimeConfig withProcessOutput(ProcessOutput value) {
        if (this.processOutput == value) {
            return this;
        }
        ProcessOutput newValue = Objects.requireNonNull(value, "processOutput");
        return new ImmutableRuntimeConfig(newValue, this.commandLinePostProcessor, this.artifactStore, this.isDaemonProcess);
    }

    public final ImmutableRuntimeConfig withCommandLinePostProcessor(CommandLinePostProcessor value) {
        if (this.commandLinePostProcessor == value) {
            return this;
        }
        CommandLinePostProcessor newValue = Objects.requireNonNull(value, "commandLinePostProcessor");
        return new ImmutableRuntimeConfig(this.processOutput, newValue, this.artifactStore, this.isDaemonProcess);
    }

    public final ImmutableRuntimeConfig withArtifactStore(IArtifactStore value) {
        if (this.artifactStore == value) {
            return this;
        }
        IArtifactStore newValue = Objects.requireNonNull(value, "artifactStore");
        return new ImmutableRuntimeConfig(this.processOutput, this.commandLinePostProcessor, newValue, this.isDaemonProcess);
    }

    public final ImmutableRuntimeConfig withIsDaemonProcess(boolean value) {
        if (this.isDaemonProcess == value) {
            return this;
        }
        return new ImmutableRuntimeConfig(this.processOutput, this.commandLinePostProcessor, this.artifactStore, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRuntimeConfig && this.equalTo(0, (ImmutableRuntimeConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableRuntimeConfig another) {
        return this.processOutput.equals(another.processOutput) && this.commandLinePostProcessor.equals(another.commandLinePostProcessor) && this.artifactStore.equals(another.artifactStore) && this.isDaemonProcess == another.isDaemonProcess;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.processOutput.hashCode();
        h += (h << 5) + this.commandLinePostProcessor.hashCode();
        h += (h << 5) + this.artifactStore.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isDaemonProcess);
        return h;
    }

    public String toString() {
        return "RuntimeConfig{processOutput=" + this.processOutput + ", commandLinePostProcessor=" + this.commandLinePostProcessor + ", artifactStore=" + this.artifactStore + ", isDaemonProcess=" + this.isDaemonProcess + "}";
    }

    public static ImmutableRuntimeConfig copyOf(RuntimeConfig instance) {
        if (instance instanceof ImmutableRuntimeConfig) {
            return (ImmutableRuntimeConfig)instance;
        }
        return ImmutableRuntimeConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RuntimeConfig", generator="Immutables")
    public static final class Builder
    implements RuntimeConfig.Builder {
        private static final long INIT_BIT_PROCESS_OUTPUT = 1L;
        private static final long INIT_BIT_ARTIFACT_STORE = 2L;
        private static final long OPT_BIT_IS_DAEMON_PROCESS = 1L;
        private long initBits = 3L;
        private long optBits;
        private ProcessOutput processOutput;
        private CommandLinePostProcessor commandLinePostProcessor;
        private IArtifactStore artifactStore;
        private boolean isDaemonProcess;

        private Builder() {
        }

        public final Builder from(RuntimeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.processOutput(instance.processOutput());
            this.commandLinePostProcessor(instance.commandLinePostProcessor());
            this.artifactStore(instance.artifactStore());
            this.isDaemonProcess(instance.isDaemonProcess());
            return this;
        }

        @Override
        public final Builder processOutput(ProcessOutput processOutput) {
            this.processOutput = Objects.requireNonNull(processOutput, "processOutput");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder commandLinePostProcessor(CommandLinePostProcessor commandLinePostProcessor) {
            this.commandLinePostProcessor = Objects.requireNonNull(commandLinePostProcessor, "commandLinePostProcessor");
            return this;
        }

        public final Builder artifactStore(IArtifactStore artifactStore) {
            this.artifactStore = Objects.requireNonNull(artifactStore, "artifactStore");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder isDaemonProcess(boolean isDaemonProcess) {
            this.isDaemonProcess = isDaemonProcess;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableRuntimeConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRuntimeConfig(this);
        }

        private boolean isDaemonProcessIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("processOutput");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactStore");
            }
            return "Cannot build RuntimeConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="RuntimeConfig", generator="Immutables")
    private final class InitShim {
        private byte commandLinePostProcessorBuildStage = 0;
        private CommandLinePostProcessor commandLinePostProcessor;
        private byte isDaemonProcessBuildStage = 0;
        private boolean isDaemonProcess;

        private InitShim() {
        }

        CommandLinePostProcessor commandLinePostProcessor() {
            if (this.commandLinePostProcessorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commandLinePostProcessorBuildStage == 0) {
                this.commandLinePostProcessorBuildStage = (byte)-1;
                this.commandLinePostProcessor = Objects.requireNonNull(ImmutableRuntimeConfig.this.commandLinePostProcessorInitialize(), "commandLinePostProcessor");
                this.commandLinePostProcessorBuildStage = 1;
            }
            return this.commandLinePostProcessor;
        }

        void commandLinePostProcessor(CommandLinePostProcessor commandLinePostProcessor) {
            this.commandLinePostProcessor = commandLinePostProcessor;
            this.commandLinePostProcessorBuildStage = 1;
        }

        boolean isDaemonProcess() {
            if (this.isDaemonProcessBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isDaemonProcessBuildStage == 0) {
                this.isDaemonProcessBuildStage = (byte)-1;
                this.isDaemonProcess = ImmutableRuntimeConfig.this.isDaemonProcessInitialize();
                this.isDaemonProcessBuildStage = 1;
            }
            return this.isDaemonProcess;
        }

        void isDaemonProcess(boolean isDaemonProcess) {
            this.isDaemonProcess = isDaemonProcess;
            this.isDaemonProcessBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.commandLinePostProcessorBuildStage == -1) {
                attributes.add("commandLinePostProcessor");
            }
            if (this.isDaemonProcessBuildStage == -1) {
                attributes.add("isDaemonProcess");
            }
            return "Cannot build RuntimeConfig, attribute initializers form cycle " + attributes;
        }
    }
}

