/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Network {
    private static final Logger logger = LoggerFactory.getLogger(Network.class);
    private static final String NO_LOCALHOST_ERROR_MESSAGE = "We could not detect if localhost is IPv4 or IPv6. Sometimes there is no entry for localhost. If 'ping localhost' does not work, it could help to add the right entry in your hosts configuration file.";
    private static final int IPV4_LENGTH = 4;

    private Network() {
        throw new IllegalAccessError("singleton");
    }

    public static boolean localhostIsIPv6() throws UnknownHostException {
        try {
            InetAddress addr = Network.getLocalHost();
            byte[] ipAddr = addr.getAddress();
            return ipAddr.length > 4;
        }
        catch (UnknownHostException ux) {
            logger.error(NO_LOCALHOST_ERROR_MESSAGE, (Throwable)ux);
            throw ux;
        }
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress ret = InetAddress.getLocalHost();
        if (!ret.isLoopbackAddress() || ret.getHostAddress().equals("127.0.1.1")) {
            ret = Network.localHostByName();
        }
        return ret;
    }

    private static InetAddress localHostByName() throws UnknownHostException {
        InetAddress ret = InetAddress.getByName("localhost");
        if (!ret.isLoopbackAddress()) {
            logger.error("{} is not a loopback address", (Object)ret.getHostAddress());
        }
        return ret;
    }

    public static int getPreferredFreeServerPort(int preferredPort) throws IOException {
        return Network.getPreferredFreeServerPort(Network.getLocalHost(), preferredPort);
    }

    public static int getFreeServerPort() throws IOException {
        return Network.getFreeServerPort(Network.getLocalHost());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPreferredFreeServerPort(InetAddress hostAddress, int preferredPort) throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(preferredPort, 0, hostAddress);){
            int n = preferredPort;
            return n;
        }
        catch (IOException e) {
            return Network.getFreeServerPort(hostAddress);
        }
    }

    public static int getFreeServerPort(InetAddress hostAddress) throws IOException {
        int[] ports = Network.getFreeServerPorts(hostAddress, 10);
        return Network.randomEntryOf(ports);
    }

    public static int randomEntryOf(int[] ports) {
        return ports[ThreadLocalRandom.current().nextInt(ports.length)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getFreeServerPorts(InetAddress hostAddress, int poolSize) throws IOException {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize < 1: " + poolSize);
        }
        ServerSocket[] sockets = new ServerSocket[poolSize];
        int[] ports = new int[poolSize];
        int idx = 0;
        try {
            do {
                sockets[idx] = new ServerSocket(0, 0, hostAddress);
                ports[idx] = sockets[idx].getLocalPort();
            } while (++idx < poolSize);
            int[] nArray = ports;
            return nArray;
        }
        finally {
            for (int i = 0; i < idx; ++i) {
                sockets[i].close();
            }
        }
    }
}

