/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.Slf4jLevel;
import org.slf4j.Logger;

public class Slf4jStreamProcessor
implements IStreamProcessor {
    private final Logger logger;
    private final Slf4jLevel level;

    public Slf4jStreamProcessor(Logger logger, Slf4jLevel level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void process(String line) {
        this.level.log(this.logger, this.stripLineEndings(line), new Object[0]);
    }

    @Override
    public void onProcessed() {
    }

    protected String stripLineEndings(String line) {
        return line.replaceAll("[\n\r]+", "");
    }
}

