package de.flapdoodle.embed.mongo.packageresolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PlatformMatchRule}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePlatformMatchRule.builder()}.
 */
@Generated(from = "PlatformMatchRule", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutablePlatformMatchRule
    implements PlatformMatchRule {
  private final DistributionMatch match;
  private final PackageFinder finder;

  private ImmutablePlatformMatchRule(
      DistributionMatch match,
      PackageFinder finder) {
    this.match = match;
    this.finder = finder;
  }

  /**
   * @return The value of the {@code match} attribute
   */
  @Override
  public DistributionMatch match() {
    return match;
  }

  /**
   * @return The value of the {@code finder} attribute
   */
  @Override
  public PackageFinder finder() {
    return finder;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PlatformMatchRule#match() match} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for match
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlatformMatchRule withMatch(DistributionMatch value) {
    if (this.match == value) return this;
    DistributionMatch newValue = Objects.requireNonNull(value, "match");
    return new ImmutablePlatformMatchRule(newValue, this.finder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PlatformMatchRule#finder() finder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for finder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlatformMatchRule withFinder(PackageFinder value) {
    if (this.finder == value) return this;
    PackageFinder newValue = Objects.requireNonNull(value, "finder");
    return new ImmutablePlatformMatchRule(this.match, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePlatformMatchRule} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePlatformMatchRule
        && equalTo((ImmutablePlatformMatchRule) another);
  }

  private boolean equalTo(ImmutablePlatformMatchRule another) {
    return match.equals(another.match)
        && finder.equals(another.finder);
  }

  /**
   * Computes a hash code from attributes: {@code match}, {@code finder}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + match.hashCode();
    h += (h << 5) + finder.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PlatformMatchRule} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PlatformMatchRule{"
        + "match=" + match
        + ", finder=" + finder
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PlatformMatchRule} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PlatformMatchRule instance
   */
  public static ImmutablePlatformMatchRule copyOf(PlatformMatchRule instance) {
    if (instance instanceof ImmutablePlatformMatchRule) {
      return (ImmutablePlatformMatchRule) instance;
    }
    return ((ImmutablePlatformMatchRule.Builder) ImmutablePlatformMatchRule.builder())
        .match(instance.match())
        .finder(instance.finder())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePlatformMatchRule ImmutablePlatformMatchRule}.
   * <pre>
   * ImmutablePlatformMatchRule.builder()
   *    .match(de.flapdoodle.embed.mongo.packageresolver.DistributionMatch) // required {@link PlatformMatchRule#match() match}
   *    .finder(de.flapdoodle.embed.mongo.packageresolver.PackageFinder) // required {@link PlatformMatchRule#finder() finder}
   *    .build();
   * </pre>
   * @return A new ImmutablePlatformMatchRule builder
   */
  public static MatchBuildStage builder() {
    return new ImmutablePlatformMatchRule.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePlatformMatchRule ImmutablePlatformMatchRule}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PlatformMatchRule", generator = "Immutables")
  public static final class Builder implements MatchBuildStage, FinderBuildStage, BuildFinal {
    private static final long INIT_BIT_MATCH = 0x1L;
    private static final long INIT_BIT_FINDER = 0x2L;
    private long initBits = 0x3L;

    private DistributionMatch match;
    private PackageFinder finder;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link PlatformMatchRule#match() match} attribute.
     * @param match The value for match 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder match(DistributionMatch match) {
      checkNotIsSet(matchIsSet(), "match");
      this.match = Objects.requireNonNull(match, "match");
      initBits &= ~INIT_BIT_MATCH;
      return this;
    }

    /**
     * Initializes the value for the {@link PlatformMatchRule#finder() finder} attribute.
     * @param finder The value for finder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder finder(PackageFinder finder) {
      checkNotIsSet(finderIsSet(), "finder");
      this.finder = Objects.requireNonNull(finder, "finder");
      initBits &= ~INIT_BIT_FINDER;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePlatformMatchRule ImmutablePlatformMatchRule}.
     * @return An immutable instance of PlatformMatchRule
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePlatformMatchRule build() {
      checkRequiredAttributes();
      return new ImmutablePlatformMatchRule(match, finder);
    }

    private boolean matchIsSet() {
      return (initBits & INIT_BIT_MATCH) == 0;
    }

    private boolean finderIsSet() {
      return (initBits & INIT_BIT_FINDER) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of PlatformMatchRule is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!matchIsSet()) attributes.add("match");
      if (!finderIsSet()) attributes.add("finder");
      return "Cannot build PlatformMatchRule, some of required attributes are not set " + attributes;
    }
  }

  @Generated(from = "PlatformMatchRule", generator = "Immutables")
  public interface MatchBuildStage {
    /**
     * Initializes the value for the {@link PlatformMatchRule#match() match} attribute.
     * @param match The value for match 
     * @return {@code this} builder for use in a chained invocation
     */
    FinderBuildStage match(DistributionMatch match);
  }

  @Generated(from = "PlatformMatchRule", generator = "Immutables")
  public interface FinderBuildStage {
    /**
     * Initializes the value for the {@link PlatformMatchRule#finder() finder} attribute.
     * @param finder The value for finder 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal finder(PackageFinder finder);
  }

  @Generated(from = "PlatformMatchRule", generator = "Immutables")
  public interface BuildFinal {

    /**
     * Builds a new {@link ImmutablePlatformMatchRule ImmutablePlatformMatchRule}.
     * @return An immutable instance of PlatformMatchRule
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    ImmutablePlatformMatchRule build();
  }
}
