/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.tests;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.Defaults;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodForTestsFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)MongodForTestsFactory.class.getName());
    private final MongodExecutable mongodExecutable;
    private final MongodProcess mongodProcess;

    public static MongodForTestsFactory with(IFeatureAwareVersion version) throws IOException {
        return new MongodForTestsFactory(version);
    }

    public MongodForTestsFactory() throws IOException {
        this(Version.Main.PRODUCTION);
    }

    public MongodForTestsFactory(IFeatureAwareVersion version) throws IOException {
        MongodStarter runtime = MongodStarter.getInstance((RuntimeConfig)Defaults.runtimeConfigFor(Command.MongoD, logger).build());
        this.mongodExecutable = (MongodExecutable)runtime.prepare(this.newMongodConfig(version));
        this.mongodProcess = (MongodProcess)this.mongodExecutable.start();
    }

    protected MongodConfig newMongodConfig(IFeatureAwareVersion version) throws IOException {
        return MongodConfig.builder().version(version).build();
    }

    public MongoClient newMongo() throws UnknownHostException {
        return new MongoClient(new ServerAddress(((MongodConfig)this.mongodProcess.getConfig()).net().getServerAddress(), ((MongodConfig)this.mongodProcess.getConfig()).net().getPort()));
    }

    @Deprecated
    public DB newDB(Mongo mongo) {
        return mongo.getDB(UUID.randomUUID().toString());
    }

    public MongoDatabase newDatabase(MongoClient mongo) {
        return mongo.getDatabase(UUID.randomUUID().toString());
    }

    public void shutdown() {
        this.mongodProcess.stop();
        this.mongodExecutable.stop();
    }
}

