/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.HasExplanation;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.linux.UbuntuPackageFinder;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.ImmutablePlatform;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Platform;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.DebianVersion;
import de.flapdoodle.os.linux.UbuntuVersion;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Deprecated
public class DebianUsesUbuntuPackageFinder
implements PackageFinder,
HasExplanation {
    private final UbuntuPackageFinder ubuntuPackageFinder;

    public DebianUsesUbuntuPackageFinder(UbuntuPackageFinder ubuntuPackageFinder) {
        this.ubuntuPackageFinder = ubuntuPackageFinder;
    }

    @Override
    public Optional<Package> packageFor(Distribution distribution) {
        if (PlatformMatch.withOs((OS)CommonOS.Linux).withVersion(new Version[]{DebianVersion.DEBIAN_12, DebianVersion.DEBIAN_13}).match(distribution)) {
            if (!distribution.platform().version().isPresent()) {
                throw new RuntimeException("version not set: " + distribution);
            }
            Version currentVersion = (Version)distribution.platform().version().get();
            Distribution asUbuntudistribution = Distribution.of((de.flapdoodle.embed.process.distribution.Version)distribution.version(), (Platform)ImmutablePlatform.copyOf((Platform)distribution.platform()).withVersion((Version)DebianUsesUbuntuPackageFinder.matchingUbuntuVersion((DebianVersion)currentVersion)));
            return this.ubuntuPackageFinder.packageFor(asUbuntudistribution);
        }
        return Optional.empty();
    }

    @Override
    public String explain() {
        List ubuntuVersions = Stream.of(DebianVersion.DEBIAN_12, DebianVersion.DEBIAN_13).map(DebianUsesUbuntuPackageFinder::matchingUbuntuVersion).distinct().collect(Collectors.toList());
        return ubuntuVersions.stream().map(uv -> Arrays.stream(DebianVersion.values()).filter(v -> DebianUsesUbuntuPackageFinder.matchingUbuntuVersion(v) == uv).map(Enum::name).collect(Collectors.joining(", ", "" + uv.name() + " for ", ""))).collect(Collectors.joining(" and ", "use ", ""));
    }

    private static UbuntuVersion matchingUbuntuVersion(DebianVersion debianVersion) {
        switch (debianVersion) {
            case DEBIAN_12: 
            case DEBIAN_13: {
                return UbuntuVersion.Ubuntu_22_04;
            }
        }
        throw new IllegalArgumentException("no matching fake ubuntu version for " + debianVersion);
    }
}

