/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.util;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static File ensureDir(File parent, String path) {
        return ResourceUtils.ensureDir(new File(parent, path));
    }

    public static File ensureDir(File dir) {
        if (dir != null) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File copy(String resourcePath, File targetDir, String targetName) throws IOException {
        return ResourceUtils.copy(resourcePath, targetDir, targetName, null);
    }

    public static File copy(String resourcePath, File targetDir, String targetName, Map<String, String> model) throws IOException {
        return ResourceUtils.copy(resourcePath, new File(targetDir, targetName), model);
    }

    public static File copy(String resourcePath, File target, Map<String, String> model) throws IOException {
        InputStream input = ResourceUtils.class.getResource(resourcePath).openStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteStreams.copy((InputStream)input, (OutputStream)out);
        String template = new String(out.toByteArray());
        if (model != null) {
            for (Map.Entry<String, String> entry : model.entrySet()) {
                template = template.replace(entry.getKey(), entry.getValue());
            }
        }
        if (target.getParentFile() != null) {
            target.getParentFile().mkdirs();
        }
        FileWriter writer = new FileWriter(target);
        writer.write(template);
        writer.close();
        return target;
    }

    public static void copyDirectory(File source, File target) throws IOException {
        String[] files;
        if (source == null) {
            return;
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((files = source.list()) != null) {
            for (String fileName : files) {
                File s = new File(source, fileName);
                File t = new File(target, fileName);
                if (s.isDirectory()) {
                    ResourceUtils.copyDirectory(s, t);
                    continue;
                }
                ResourceUtils.copy(s, t);
            }
        }
    }

    public static void copy(File source, File target) throws IOException {
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(target);){
            int length;
            byte[] buf = new byte[1024];
            while ((length = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, length);
            }
        }
    }

    public static boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ResourceUtils.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return directory.delete();
    }
}

