/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.task;

import com.google.common.collect.ImmutableMap;
import de.esoco.gwt.gradle.extension.GwtExtension;
import de.esoco.gwt.gradle.task.AbstractTask;
import de.esoco.gwt.gradle.util.ResourceUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class GwtSetUpTask
extends AbstractTask {
    public static final String NAME = "gwtSetUp";
    @Input
    private List<String> modules;

    public GwtSetUpTask() {
        this.setDescription("Set up the GWT project from a skeleton");
    }

    public static boolean isEnable(Project project, GwtExtension extension) {
        String mainModule = null;
        if (extension.getModule() != null && extension.getModule().size() > 0) {
            mainModule = extension.getModule().get(0);
        }
        if (mainModule != null) {
            String moduleFilePath = "src/main/java/" + mainModule.replaceAll("\\.", "/") + ".gwt.xml";
            File moduleFile = new File(project.getProjectDir(), moduleFilePath);
            return !moduleFile.exists();
        }
        return false;
    }

    public void configure(final GwtExtension extension) {
        ConventionMapping mapping = ((IConventionAware)this).getConventionMapping();
        mapping.map("modules", (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() {
                return extension.getModule();
            }
        });
    }

    @TaskAction
    public void exec() throws Exception {
        GwtExtension extension = (GwtExtension)this.getProject().getExtensions().getByType(GwtExtension.class);
        File projectDir = this.getProject().getProjectDir();
        File srcMainJava = ResourceUtils.ensureDir(new File(projectDir, "src/main/java"));
        File srcMainWebapp = ResourceUtils.ensureDir(new File(projectDir, "src/main/webapp"));
        for (String module : extension.getModule()) {
            String moduleName = module.substring(module.lastIndexOf(46) + 1);
            String packageName = module.substring(0, module.lastIndexOf(46));
            String packagePath = packageName.replaceAll("\\.", "/");
            File moduleDir = ResourceUtils.ensureDir(new File(srcMainJava, packagePath));
            File clientDir = ResourceUtils.ensureDir(new File(moduleDir, "client"));
            ImmutableMap model = new ImmutableMap.Builder().put((Object)"__APP_NAME__", (Object)moduleName).put((Object)"__PKG_NAME__", (Object)packageName).build();
            ResourceUtils.copy("/skeleton/gwt.xml.txt", new File(moduleDir, moduleName + ".gwt.xml"), (Map<String, String>)model);
            ResourceUtils.copy("/skeleton/entryPoint.java.txt", new File(clientDir, moduleName + ".java"), (Map<String, String>)model);
            ResourceUtils.copy("/skeleton/entryPoint.ui.xml.txt", new File(clientDir, moduleName + ".ui.xml"), (Map<String, String>)model);
            ResourceUtils.copy("/skeleton/index.html.txt", new File(srcMainWebapp, "index.html"), (Map<String, String>)model);
        }
    }

    public List<String> getModules() {
        return this.modules;
    }
}

