/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle.command;

import de.esoco.gwt.gradle.command.AbstractCommand;
import de.esoco.gwt.gradle.extension.CompilerOption;
import java.io.File;
import java.util.Collection;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;

public class CompileCommand
extends AbstractCommand {
    public CompileCommand(Project project, CompilerOption compilerOptions, FileCollection sources, File war, Collection<String> modules) {
        super(project, "com.google.gwt.dev.Compiler");
        this.configure(project, compilerOptions, sources, war, modules);
    }

    private void configure(Project project, CompilerOption compilerOptions, FileCollection sources, File war, Collection<String> modules) {
        Configuration sdmConf = project.getConfigurations().getByName("gwtSdk");
        Configuration compileConf = project.getConfigurations().getByName("compileClasspath");
        this.configureJavaArgs(compilerOptions);
        this.addJavaArgs("-Dgwt.persistentunitcachedir=" + project.getBuildDir() + "/" + "gwt" + "/work/cache");
        for (File sourceDir : sources) {
            this.addClassPath(sourceDir.getAbsolutePath());
        }
        Collection<File> deps = this.getDependencySourceDirs(project);
        for (File sourceDir : deps) {
            this.addClassPath(sourceDir.getAbsolutePath());
        }
        this.addClassPath(compileConf.getAsPath());
        this.addClassPath(sdmConf.getAsPath());
        this.addArg("-war", war);
        this.addArg("-extra", compilerOptions.getExtra());
        this.addArg("-workDir", compilerOptions.getWorkDir());
        this.addArg("-gen", compilerOptions.getGen());
        this.addArg("-deploy", compilerOptions.getDeploy());
        this.addArg("-logLevel", (Object)compilerOptions.getLogLevel());
        this.addArg("-localWorkers", compilerOptions.getLocalWorkers());
        this.addArgIf(compilerOptions.getStrict(), "-strict");
        this.addArgIf(compilerOptions.getFailOnError(), "-failOnError", "-nofailOnError");
        this.addArg("-sourceLevel", compilerOptions.getSourceLevel());
        this.addArgIf(compilerOptions.getDraftCompile(), "-draftCompile", "-nodraftCompile");
        this.addArg("-optimize", compilerOptions.getOptimize());
        this.addArg("-style", (Object)compilerOptions.getStyle());
        this.addArgIf(compilerOptions.getCompileReport(), "-compileReport", "-nocompileReport");
        this.addArgIf(compilerOptions.getIncremental(), "-incremental");
        this.addArgIf(compilerOptions.getCheckAssertions(), "-checkAssertions", "-nocheckAssertions");
        this.addArgIf(compilerOptions.getCheckCasts(), "-XcheckCasts", "-XnocheckCasts");
        this.addArgIf(compilerOptions.getEnforceStrictResources(), "-XenforceStrictResources", "-XnoenforceStrictResources");
        this.addArgIf(compilerOptions.getClassMetadata(), "-XclassMetadata", "-XnoclassMetadata");
        this.addArgIf(compilerOptions.getOverlappingSourceWarnings(), "-overlappingSourceWarnings", "-nooverlappingSourceWarnings");
        this.addArgIf(compilerOptions.getSaveSource(), "-saveSource", "-nosaveSource");
        this.addArg("-XmethodNameDisplayMode", (Object)compilerOptions.getMethodNameDisplayMode());
        this.addArg("-XjsInteropMode", (Object)compilerOptions.getJsInteropMode());
        if (compilerOptions.getGenerateJsInteropExports()) {
            this.addArg("-generateJsInteropExports");
            if (compilerOptions.getIncludeJsInteropExports() != null) {
                for (String arg : compilerOptions.getIncludeJsInteropExports()) {
                    this.addArg("-includeJsInteropExports", arg);
                }
            }
            if (compilerOptions.getExcludeJsInteropExports() != null) {
                for (String arg : compilerOptions.getExcludeJsInteropExports()) {
                    this.addArg("-excludeJsInteropExports", arg);
                }
            }
        }
        if (compilerOptions.getExtraArgs() != null) {
            for (String arg : compilerOptions.getExtraArgs()) {
                this.addArg(arg);
            }
        }
        for (String module : modules) {
            this.addArg(module);
        }
    }
}

