/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.gwt.gradle;

import de.esoco.gwt.gradle.GwtPlugin;
import de.esoco.gwt.gradle.extension.GwtExtension;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;

public class GwtLibPlugin
implements Plugin<Project> {
    public static final String CONF_GWT_SDK = "gwtSdk";
    public static final String CONF_JETTY = "jettyConf";
    private static final String ECLIPSE_NATURE = "com.gwtplugins.gwt.eclipse.core.gwtNature";
    private static final String ECLIPSE_GWT_CONTAINER = "com.gwtplugins.gwt.eclipse.core.GWT_CONTAINER";
    private static final String ECLIPSE_BUILDER_PROJECT_VALIDATOR = "com.gwtplugins.gwt.eclipse.core.gwtProjectValidator";
    private static final String ECLIPSE_BUILDER_WEBAPP_VALIDATOR = "com.gwtplugins.gdt.eclipse.core.webAppProjectValidator";

    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        project.getPlugins().apply(MavenPublishPlugin.class);
        GwtExtension extension = (GwtExtension)project.getExtensions().create("gwt", GwtExtension.class, new Object[0]);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        ((Configuration)configurationContainer.create(CONF_GWT_SDK)).setVisible(false);
        ((Configuration)configurationContainer.create(CONF_JETTY)).setVisible(false);
        this.includeSourcesToJar(project);
        project.afterEvaluate(p -> this.initDependencies(project, extension));
    }

    private void includeSourcesForTest(Project project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourset = (SourceSet)javaConvention.getSourceSets().getByName("main");
        SourceSet testSourset = (SourceSet)javaConvention.getSourceSets().getByName("test");
        FileCollection testClasspath = project.files(mainSourset.getAllSource().getSrcDirs().toArray()).plus((FileCollection)project.files(testSourset.getAllSource().getSrcDirs().toArray())).plus(testSourset.getRuntimeClasspath());
        testSourset.setRuntimeClasspath(testClasspath);
        Test test = (Test)project.getTasks().withType(Test.class).getByName("test");
        test.getSystemProperties().put("gwt.persistentunitcachedir", project.getBuildDir() + "gwt" + "/test");
    }

    private void includeSourcesToJar(Project project) {
        Jar jarTask = (Jar)project.getTasks().withType(Jar.class).getByName("jar");
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourset = (SourceSet)javaConvention.getSourceSets().getByName("main");
        jarTask.from(new Object[]{mainSourset.getAllSource()});
    }

    private void initDependencies(Project project, GwtExtension extension) {
        String gwtVersion = extension.getGwtVersion();
        String jettyVersion = extension.getJettyVersion();
        String sGwtUser = "com.google.gwt:gwt-user:" + gwtVersion;
        String sGwtCodeserver = "com.google.gwt:gwt-codeserver:" + gwtVersion;
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add(CONF_GWT_SDK, (Object)sGwtCodeserver);
        dependencies.add(CONF_GWT_SDK, (Object)sGwtUser);
        dependencies.add("compileOnly", (Object)sGwtCodeserver);
        dependencies.add("compileOnly", (Object)sGwtUser);
        dependencies.add("compileOnly", (Object)sGwtUser);
        if (extension.isGwtElementalLib()) {
            dependencies.add("implementation", (Object)("com.google.gwt:gwt-elemental:" + gwtVersion));
        }
        if (extension.isGwtServletLib()) {
            dependencies.add("implementation", (Object)("com.google.gwt:gwt-servlet:" + gwtVersion));
        }
        if (project.getPlugins().hasPlugin(WarPlugin.class)) {
            dependencies.add("providedCompile", (Object)("com.google.gwt:gwt-dev:" + gwtVersion));
        }
        dependencies.add(CONF_JETTY, (Object)("org.eclipse.jetty:jetty-runner:" + jettyVersion));
        this.includeSourcesForTest(project);
        this.initGwtEclipsePlugin(project);
    }

    private void initGwtEclipsePlugin(Project project) {
        GwtExtension gwtExtension = (GwtExtension)project.getExtensions().getByName("gwt");
        if (project.getPlugins().hasPlugin("eclipse") && gwtExtension.isGwtPluginEclipse()) {
            EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
            final EclipseProject eclipseProject = eclipseModel.getProject();
            eclipseProject.natures(new String[]{ECLIPSE_NATURE});
            eclipseProject.buildCommand(ECLIPSE_BUILDER_PROJECT_VALIDATOR);
            eclipseModel.getClasspath().getContainers().add(ECLIPSE_GWT_CONTAINER);
            project.getPlugins().withType(GwtPlugin.class, (Action)new Action<GwtPlugin>(){

                public void execute(GwtPlugin warPlugin) {
                    eclipseProject.buildCommand(GwtLibPlugin.ECLIPSE_BUILDER_WEBAPP_VALIDATOR);
                }
            });
        }
    }
}

