/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.inclusion;

import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.category.CategoryResolver;
import de.danielbechler.diff.inclusion.CategoryInclusionResolver;
import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.InclusionConfigurer;
import de.danielbechler.diff.inclusion.InclusionResolver;
import de.danielbechler.diff.inclusion.IsIgnoredResolver;
import de.danielbechler.diff.inclusion.NodePathInclusionResolver;
import de.danielbechler.diff.inclusion.PropertyNameInclusionResolver;
import de.danielbechler.diff.inclusion.TypeInclusionResolver;
import de.danielbechler.diff.inclusion.TypePropertyAnnotationInclusionResolver;
import de.danielbechler.diff.inclusion.TypePropertyConfigInclusionResolver;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.path.NodePath;
import de.danielbechler.util.Assert;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InclusionService
implements InclusionConfigurer,
IsIgnoredResolver {
    private final ObjectDifferBuilder rootConfiguration;
    private final CategoryResolver categoryResolver;
    private final Collection<InclusionResolver> inclusionResolvers = new LinkedList<InclusionResolver>();
    private TypeInclusionResolver typeInclusionResolver;
    private TypePropertyConfigInclusionResolver typePropertyConfigInclusionResolver;
    private CategoryInclusionResolver categoryInclusionResolver;
    private NodePathInclusionResolver nodePathInclusionResolver;
    private PropertyNameInclusionResolver propertyNameInclusionResolver;

    public InclusionService(CategoryResolver categoryResolver, ObjectDifferBuilder rootConfiguration) {
        Assert.notNull(rootConfiguration, "rootConfiguration");
        Assert.notNull(categoryResolver, "categoryResolver");
        this.rootConfiguration = rootConfiguration;
        this.categoryResolver = categoryResolver;
        this.addAlwaysOnInclusionResolvers();
    }

    private void addAlwaysOnInclusionResolvers() {
        this.inclusionResolvers.add(new TypePropertyAnnotationInclusionResolver());
    }

    Collection<InclusionResolver> getInclusionResolvers() {
        return this.inclusionResolvers;
    }

    @Override
    public boolean isIgnored(DiffNode node) {
        if (node.isRootNode()) {
            return false;
        }
        boolean strictIncludeModeEnabled = false;
        boolean isExplicitlyIncluded = false;
        for (InclusionResolver inclusionResolver : this.inclusionResolvers) {
            if (inclusionResolver.enablesStrictIncludeMode()) {
                strictIncludeModeEnabled = true;
            }
            switch (InclusionService.getInclusion(node, inclusionResolver)) {
                case EXCLUDED: {
                    return true;
                }
                case INCLUDED: {
                    isExplicitlyIncluded = true;
                }
            }
        }
        return strictIncludeModeEnabled && !isExplicitlyIncluded;
    }

    private static Inclusion getInclusion(DiffNode node, InclusionResolver inclusionResolver) {
        Inclusion inclusion = inclusionResolver.getInclusion(node);
        return inclusion != null ? inclusion : Inclusion.DEFAULT;
    }

    @Override
    public InclusionConfigurer.ToInclude include() {
        return new InclusionConfigurer.ToInclude(){

            @Override
            public InclusionConfigurer.ToInclude category(String category) {
                InclusionService.this.setCategoryInclusion(Inclusion.INCLUDED, category);
                return this;
            }

            @Override
            public InclusionConfigurer.ToInclude type(Class<?> type) {
                InclusionService.this.setTypeInclusion(Inclusion.INCLUDED, type);
                return this;
            }

            @Override
            public InclusionConfigurer.ToInclude node(NodePath nodePath) {
                InclusionService.this.setNodePathInclusion(Inclusion.INCLUDED, nodePath);
                return this;
            }

            @Override
            public InclusionConfigurer.ToInclude propertyName(String propertyName) {
                InclusionService.this.setPropertyNameInclusion(Inclusion.INCLUDED, propertyName);
                return this;
            }

            @Override
            public InclusionConfigurer.ToInclude propertyNameOfType(Class<?> type, String ... propertyNames) {
                InclusionService.this.setPropertyNameOfTypeInclusion(Inclusion.INCLUDED, type, propertyNames);
                return this;
            }

            @Override
            public InclusionConfigurer also() {
                return InclusionService.this;
            }

            @Override
            public ObjectDifferBuilder and() {
                return InclusionService.this.rootConfiguration;
            }
        };
    }

    void setCategoryInclusion(Inclusion inclusion, String category) {
        if (this.categoryInclusionResolver == null) {
            this.categoryInclusionResolver = this.newCategoryInclusionResolver();
            this.inclusionResolvers.add(this.categoryInclusionResolver);
        }
        this.categoryInclusionResolver.setInclusion(category, inclusion);
    }

    void setTypeInclusion(Inclusion inclusion, Class<?> type) {
        if (this.typeInclusionResolver == null) {
            this.typeInclusionResolver = this.newTypeInclusionResolver();
            this.inclusionResolvers.add(this.typeInclusionResolver);
        }
        this.typeInclusionResolver.setInclusion(type, inclusion);
    }

    void setNodePathInclusion(Inclusion inclusion, NodePath nodePath) {
        if (this.nodePathInclusionResolver == null) {
            this.nodePathInclusionResolver = this.newNodePathInclusionResolver();
            this.inclusionResolvers.add(this.nodePathInclusionResolver);
        }
        this.nodePathInclusionResolver.setInclusion(nodePath, inclusion);
    }

    void setPropertyNameInclusion(Inclusion inclusion, String propertyName) {
        if (this.propertyNameInclusionResolver == null) {
            this.propertyNameInclusionResolver = this.newPropertyNameInclusionResolver();
            this.inclusionResolvers.add(this.propertyNameInclusionResolver);
        }
        this.propertyNameInclusionResolver.setInclusion(propertyName, inclusion);
    }

    private void setPropertyNameOfTypeInclusion(Inclusion inclusion, Class<?> type, String ... propertyNames) {
        Assert.notNull(type, "type");
        String[] stringArray = propertyNames;
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            Assert.hasText(propertyName, "propertyName in propertyNames");
            if (this.typePropertyConfigInclusionResolver == null) {
                this.typePropertyConfigInclusionResolver = this.newTypePropertyConfigInclusionResolver();
                this.inclusionResolvers.add(this.typePropertyConfigInclusionResolver);
            }
            this.typePropertyConfigInclusionResolver.setInclusion(type, propertyName, inclusion);
            ++n2;
        }
    }

    CategoryInclusionResolver newCategoryInclusionResolver() {
        return new CategoryInclusionResolver(this.categoryResolver);
    }

    TypeInclusionResolver newTypeInclusionResolver() {
        return new TypeInclusionResolver();
    }

    NodePathInclusionResolver newNodePathInclusionResolver() {
        return new NodePathInclusionResolver();
    }

    PropertyNameInclusionResolver newPropertyNameInclusionResolver() {
        return new PropertyNameInclusionResolver();
    }

    TypePropertyConfigInclusionResolver newTypePropertyConfigInclusionResolver() {
        return new TypePropertyConfigInclusionResolver();
    }

    @Override
    public InclusionConfigurer.ToExclude exclude() {
        return new InclusionConfigurer.ToExclude(){

            @Override
            public InclusionConfigurer.ToExclude category(String category) {
                InclusionService.this.setCategoryInclusion(Inclusion.EXCLUDED, category);
                return this;
            }

            @Override
            public InclusionConfigurer.ToExclude type(Class<?> type) {
                InclusionService.this.setTypeInclusion(Inclusion.EXCLUDED, type);
                return this;
            }

            @Override
            public InclusionConfigurer.ToExclude node(NodePath nodePath) {
                InclusionService.this.setNodePathInclusion(Inclusion.EXCLUDED, nodePath);
                return this;
            }

            @Override
            public InclusionConfigurer.ToExclude propertyName(String propertyName) {
                InclusionService.this.setPropertyNameInclusion(Inclusion.EXCLUDED, propertyName);
                return this;
            }

            @Override
            public InclusionConfigurer.ToExclude propertyNameOfType(Class<?> type, String ... propertyNames) {
                InclusionService.this.setPropertyNameOfTypeInclusion(Inclusion.EXCLUDED, type, propertyNames);
                return this;
            }

            @Override
            public InclusionConfigurer also() {
                return InclusionService.this;
            }

            @Override
            public ObjectDifferBuilder and() {
                return InclusionService.this.rootConfiguration;
            }
        };
    }

    @Override
    public InclusionConfigurer resolveUsing(InclusionResolver inclusionResolver) {
        Assert.notNull(inclusionResolver, "inclusionResolver");
        this.inclusionResolvers.add(inclusionResolver);
        return this;
    }

    @Override
    public ObjectDifferBuilder and() {
        return this.rootConfiguration;
    }
}

