/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.gradle.plugin.maven.settings;

import de.comahe.gradle.plugin.maven.settings.MavenSettingsHandler;
import de.comahe.gradle.plugin.maven.settings.MavenSettingsPluginExtension;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.initialization.Settings;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.PluginAware;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.plugin.management.PluginManagementSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lde/comahe/gradle/plugin/maven/settings/MavenSettingsPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/plugins/PluginAware;", "()V", "apply", "", "pluginAware", "handleProject", "project", "Lorg/gradle/api/Project;", "handleSettings", "settings", "Lorg/gradle/api/initialization/Settings;", "gradle-maven-settings-plugin"})
public final class MavenSettingsPlugin
implements Plugin<PluginAware> {
    public void apply(@NotNull PluginAware pluginAware) {
        Intrinsics.checkNotNullParameter((Object)pluginAware, (String)"pluginAware");
        PluginAware pluginAware2 = pluginAware;
        if (pluginAware2 instanceof Project) {
            this.handleProject((Project)pluginAware);
        } else if (pluginAware2 instanceof Settings) {
            this.handleSettings((Settings)pluginAware);
        } else {
            throw (Throwable)new IllegalAccessException("The type '" + pluginAware.getClass() + "' is not supported by the 'maven-settings-plugin'");
        }
    }

    private final void handleProject(Project project) {
        Object object = project.getExtensions().create("mavenSettings", MavenSettingsPluginExtension.class, new Object[]{project.getProperties()});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026ject.properties\n        )");
        MavenSettingsPluginExtension extension = (MavenSettingsPluginExtension)object;
        project.afterEvaluate(new Action(project, extension){
            final /* synthetic */ Project $project;
            final /* synthetic */ MavenSettingsPluginExtension $extension;

            public final void execute(@NotNull Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$receiver");
                Logger logger = this.$project.getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
                MavenSettingsHandler handler = new MavenSettingsHandler(logger, this.$extension);
                File file = this.$project.getProjectDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
                handler.activateProfiles(file, (ExtraPropertiesExtension)this.$project.getExtensions().findByType(ExtraPropertiesExtension.class), this.$project.getRepositories());
                RepositoryHandler repositoryHandler = this.$project.getRepositories();
                Intrinsics.checkNotNullExpressionValue((Object)repositoryHandler, (String)"project.repositories");
                handler.registerMirrors(repositoryHandler);
                handler.applyRepoCredentials(this.$project.getRepositories());
                PublishingExtension publishingExtension = (PublishingExtension)this.$project.getExtensions().findByType(PublishingExtension.class);
                handler.applyRepoCredentials((RepositoryHandler)(publishingExtension != null ? publishingExtension.getRepositories() : null));
            }
            {
                this.$project = project;
                this.$extension = mavenSettingsPluginExtension;
            }
        });
    }

    private final void handleSettings(Settings settings) {
        ExtensionContainer extensionContainer = settings.getExtensions();
        Object[] objectArray = new Object[1];
        ExtensionContainer extensionContainer2 = settings.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer2, (String)"settings.extensions");
        ExtraPropertiesExtension extraPropertiesExtension = extensionContainer2.getExtraProperties();
        Intrinsics.checkNotNullExpressionValue((Object)extraPropertiesExtension, (String)"settings.extensions.extraProperties");
        objectArray[0] = extraPropertiesExtension.getProperties();
        Object object = extensionContainer.create("mavenSettings", MavenSettingsPluginExtension.class, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"settings.extensions.crea\u2026ties.properties\n        )");
        MavenSettingsPluginExtension extension = (MavenSettingsPluginExtension)object;
        settings.getGradle().settingsEvaluated(new Action(extension, settings){
            final /* synthetic */ MavenSettingsPluginExtension $extension;
            final /* synthetic */ Settings $settings;

            public final void execute(@NotNull Settings $this$settingsEvaluated) {
                Intrinsics.checkNotNullParameter((Object)$this$settingsEvaluated, (String)"$receiver");
                Logger logger = Logging.getLogger(Project.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logging.getLogger(Project::class.java)");
                MavenSettingsHandler handler = new MavenSettingsHandler(logger, this.$extension);
                File file = this.$settings.getRootDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"settings.rootDir");
                ExtraPropertiesExtension extraPropertiesExtension = (ExtraPropertiesExtension)this.$settings.getExtensions().findByType(ExtraPropertiesExtension.class);
                PluginManagementSpec pluginManagementSpec = this.$settings.getPluginManagement();
                Intrinsics.checkNotNullExpressionValue((Object)pluginManagementSpec, (String)"settings.pluginManagement");
                handler.activateProfiles(file, extraPropertiesExtension, pluginManagementSpec.getRepositories());
                PluginManagementSpec pluginManagementSpec2 = this.$settings.getPluginManagement();
                Intrinsics.checkNotNullExpressionValue((Object)pluginManagementSpec2, (String)"settings.pluginManagement");
                RepositoryHandler repositoryHandler = pluginManagementSpec2.getRepositories();
                Intrinsics.checkNotNullExpressionValue((Object)repositoryHandler, (String)"settings.pluginManagement.repositories");
                handler.registerMirrors(repositoryHandler);
                PluginManagementSpec pluginManagementSpec3 = this.$settings.getPluginManagement();
                Intrinsics.checkNotNullExpressionValue((Object)pluginManagementSpec3, (String)"settings.pluginManagement");
                handler.applyRepoCredentials(pluginManagementSpec3.getRepositories());
                PublishingExtension publishingExtension = (PublishingExtension)this.$settings.getExtensions().findByType(PublishingExtension.class);
                handler.applyRepoCredentials((RepositoryHandler)(publishingExtension != null ? publishingExtension.getRepositories() : null));
            }
            {
                this.$extension = mavenSettingsPluginExtension;
                this.$settings = settings;
            }
        });
    }
}

