/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.Assert;

public class Application {
    private final String name;
    private final String managementUrl;
    private final String healthUrl;
    private final String serviceUrl;
    private final Map<String, String> metadata;

    protected Application(String name, String managementUrl, String healthUrl, String serviceUrl, Map<String, String> metadata) {
        Assert.hasText((String)name, (String)"name must not be empty!");
        Assert.hasText((String)healthUrl, (String)"healthUrl must not be empty!");
        this.name = name;
        this.managementUrl = managementUrl;
        this.healthUrl = healthUrl;
        this.serviceUrl = serviceUrl;
        this.metadata = new HashMap<String, String>(metadata);
    }

    public static Builder create(String name) {
        return Application.builder().name(name);
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getManagementUrl() {
        return this.managementUrl;
    }

    @Generated
    public String getHealthUrl() {
        return this.healthUrl;
    }

    @Generated
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application other = (Application)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$managementUrl = this.getManagementUrl();
        String other$managementUrl = other.getManagementUrl();
        if (this$managementUrl == null ? other$managementUrl != null : !this$managementUrl.equals(other$managementUrl)) {
            return false;
        }
        String this$healthUrl = this.getHealthUrl();
        String other$healthUrl = other.getHealthUrl();
        if (this$healthUrl == null ? other$healthUrl != null : !this$healthUrl.equals(other$healthUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Application;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $managementUrl = this.getManagementUrl();
        result = result * 59 + ($managementUrl == null ? 43 : $managementUrl.hashCode());
        String $healthUrl = this.getHealthUrl();
        result = result * 59 + ($healthUrl == null ? 43 : $healthUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Application(name=" + this.getName() + ", managementUrl=" + this.getManagementUrl() + ", healthUrl=" + this.getHealthUrl() + ", serviceUrl=" + this.getServiceUrl() + ")";
    }

    public static class Builder {
        @Generated
        private String name;
        @Generated
        private String managementUrl;
        @Generated
        private String healthUrl;
        @Generated
        private String serviceUrl;
        @Generated
        private ArrayList<String> metadata$key;
        @Generated
        private ArrayList<String> metadata$value;

        @Generated
        Builder() {
        }

        @Generated
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public Builder managementUrl(String managementUrl) {
            this.managementUrl = managementUrl;
            return this;
        }

        @Generated
        public Builder healthUrl(String healthUrl) {
            this.healthUrl = healthUrl;
            return this;
        }

        @Generated
        public Builder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        @Generated
        public Builder metadata(String metadataKey, String metadataValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataKey);
            this.metadata$value.add(metadataValue);
            return this;
        }

        @Generated
        public Builder metadata(Map<? extends String, ? extends String> metadata) {
            if (metadata == null) {
                throw new NullPointerException("metadata cannot be null");
            }
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public Builder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        @Generated
        public Application build() {
            Map<String, String> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new Application(this.name, this.managementUrl, this.healthUrl, this.serviceUrl, metadata);
        }

        @Generated
        public String toString() {
            return "Application.Builder(name=" + this.name + ", managementUrl=" + this.managementUrl + ", healthUrl=" + this.healthUrl + ", serviceUrl=" + this.serviceUrl + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

