/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.util.Exceptions;
import de.carne.util.prefs.PropertiesPreferences;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;

public class PropertiesPreferencesFactory
implements PreferencesFactory {
    private static final String THIS_PACKAGE = Objects.requireNonNull(PropertiesPreferencesFactory.class.getPackage()).getName();
    private static final String PREFERENCES_DIR = System.getProperty(THIS_PACKAGE, "." + THIS_PACKAGE);

    @Override
    public Preferences systemRoot() {
        String userHome = PropertiesPreferencesFactory.getUserHome();
        String systemName = PropertiesPreferencesFactory.getSystemName();
        Path propertiesPath = Paths.get(userHome, PREFERENCES_DIR, "systemprefs-" + systemName + ".properties");
        return new PropertiesPreferences(propertiesPath);
    }

    @Override
    public Preferences userRoot() {
        String userHome = PropertiesPreferencesFactory.getUserHome();
        String userName = PropertiesPreferencesFactory.getUserName();
        Path propertiesPath = Paths.get(userHome, PREFERENCES_DIR, "userprefs-" + userName + ".properties");
        return new PropertiesPreferences(propertiesPath);
    }

    public static Preferences customRoot(Path propertiesPath) {
        return new PropertiesPreferences(propertiesPath);
    }

    private static String getUserHome() {
        return System.getProperty("user.home", ".");
    }

    private static String getSystemName() {
        String systemName = "localhost";
        try {
            systemName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Exceptions.ignore(e);
        }
        return systemName;
    }

    private static String getUserName() {
        return System.getProperty("user.name", "unknown");
    }
}

