/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.check.Nullable;
import java.util.function.Supplier;

public final class Lazy<T> {
    private final Supplier<T> initializer;
    @Nullable
    private T initializedObject = null;

    public Lazy(Supplier<T> initializer) {
        this.initializer = initializer;
    }

    public synchronized boolean isInitialized() {
        return this.initializedObject != null;
    }

    public synchronized T get() {
        T object = this.initializedObject;
        if (object == null) {
            object = this.initializedObject = this.initializer.get();
        }
        return object;
    }

    public String toString() {
        T object = this.initializedObject;
        return object != null ? object.toString() : "<not initialized>";
    }
}

