/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.util.prefs.PropertiesPreferences;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;

public class PropertiesPreferencesFactory
implements PreferencesFactory {
    private static final String PREFERENCES_DIR;

    @Override
    public Preferences systemRoot() {
        String systemName;
        String userHome = System.getProperty("user.home", ".");
        try {
            systemName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            systemName = "UNKNOWN";
        }
        Path propertiesPath = Paths.get(userHome, PREFERENCES_DIR, "system-" + systemName + ".properties");
        return new PropertiesPreferences(propertiesPath);
    }

    @Override
    public Preferences userRoot() {
        String userHome = System.getProperty("user.home", ".");
        Path propertiesPath = Paths.get(userHome, PREFERENCES_DIR, "user.properties");
        return new PropertiesPreferences(propertiesPath);
    }

    public static Preferences fromFile(Path propertiesPath) {
        return new PropertiesPreferences(propertiesPath);
    }

    public static File directory(String name) {
        assert (name != null);
        String userHome = System.getProperty("user.home", ".");
        Path directoryPath = Paths.get(userHome, PREFERENCES_DIR, name);
        try {
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create preference directory '" + directoryPath + "'");
        }
        return directoryPath.toFile();
    }

    static {
        String packageName = PropertiesPreferencesFactory.class.getPackage().getName();
        PREFERENCES_DIR = System.getProperty(packageName, "." + packageName);
    }
}

