/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.util.prefs.Preference;
import java.util.function.Function;
import java.util.prefs.Preferences;

public final class ObjectPreference<T>
extends Preference {
    private final Function<String, T> fromStringLambda;
    private final Function<T, String> toStringLambda;

    public ObjectPreference(String key, Function<String, T> fromStringLambda) {
        this(key, fromStringLambda, o -> o.toString());
    }

    public ObjectPreference(String key, Function<String, T> fromStringLambda, Function<T, String> toStringLambda) {
        super(key);
        assert (fromStringLambda != null);
        assert (toStringLambda != null);
        this.fromStringLambda = fromStringLambda;
        this.toStringLambda = toStringLambda;
    }

    public T get(Preferences preferences) {
        return this.get(preferences, null);
    }

    public T get(Preferences preferences, T defaultValue) {
        assert (preferences != null);
        String valueString = preferences.get(this.key(), null);
        T value = defaultValue;
        if (valueString != null) {
            value = this.fromStringLambda.apply(valueString);
        }
        return value;
    }

    public void set(Preferences preferences, T value) {
        assert (preferences != null);
        if (value != null) {
            preferences.put(this.key(), this.toStringLambda.apply(value));
        } else {
            preferences.remove(this.key());
        }
    }
}

