/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import java.util.Iterator;
import java.util.LinkedList;

public class MRUList<K, V>
extends LinkedList<Entry<K, V>> {
    private static final long serialVersionUID = 1L;
    private final int maxSize;

    public MRUList(int maxSize) {
        assert (maxSize > 0);
        this.maxSize = maxSize;
    }

    public synchronized V use(K key) {
        assert (key != null);
        Entry usedEntry = null;
        Iterator entryIterator = this.iterator();
        while (entryIterator.hasNext()) {
            Entry entry = (Entry)entryIterator.next();
            if (!key.equals(entry.getKey())) continue;
            entryIterator.remove();
            this.addFirst(entry);
            usedEntry = entry;
            break;
        }
        return usedEntry != null ? (V)usedEntry.getValue() : null;
    }

    public synchronized void use(K key, V value) {
        this.addFirst(new Entry<K, V>(key, value));
        if (this.size() > this.maxSize) {
            this.removeLast();
        }
    }

    public static final class Entry<K, V> {
        private final K key;
        private final V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

