/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.IndexKey;
import de.bwaldvogel.mongo.backend.KeyValue;
import de.bwaldvogel.mongo.backend.StreamUtils;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.CannotIndexParallelArraysError;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Index<P> {
    private final List<IndexKey> keys;
    private final boolean sparse;

    protected Index(List<IndexKey> keys, boolean sparse) {
        this.keys = keys;
        this.sparse = sparse;
    }

    protected boolean isSparse() {
        return this.sparse;
    }

    protected List<IndexKey> getKeys() {
        return this.keys;
    }

    public String getName() {
        if (this.keys.size() == 1 && CollectionUtils.getSingleElement(this.keys).getKey().equals("_id")) {
            return "_id_";
        }
        return this.keys.stream().map(indexKey -> indexKey.getKey() + "_" + (indexKey.isAscending() ? "1" : "-1")).collect(Collectors.joining("_"));
    }

    protected List<String> keys() {
        return this.keys.stream().map(IndexKey::getKey).collect(Collectors.toList());
    }

    protected Set<String> keySet() {
        return this.keys.stream().map(IndexKey::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    Set<KeyValue> getKeyValues(Document document) {
        return this.getKeyValues(document, true);
    }

    Set<KeyValue> getKeyValues(Document document, boolean normalize) {
        LinkedHashMap<String, Object> valuesPerKey = new LinkedHashMap<String, Object>();
        for (String key : this.keys()) {
            Object value = Utils.getSubdocumentValueCollectionAware(document, key);
            if (normalize) {
                value = Utils.normalizeValue(value);
            }
            valuesPerKey.put(key, value);
        }
        Map collectionValues = valuesPerKey.entrySet().stream().filter(entry -> entry.getValue() instanceof Collection).collect(StreamUtils.toLinkedHashMap());
        if (collectionValues.size() == 1) {
            Collection collectionValue = (Collection)CollectionUtils.getSingleElement(collectionValues.values());
            return CollectionUtils.multiplyWithOtherElements(valuesPerKey.values(), collectionValue).stream().map(KeyValue::new).collect(StreamUtils.toLinkedHashSet());
        }
        if (collectionValues.size() > 1) {
            throw new CannotIndexParallelArraysError(collectionValues.keySet());
        }
        return Collections.singleton(new KeyValue(valuesPerKey.values()));
    }

    public abstract void checkAdd(Document var1, MongoCollection<P> var2);

    public abstract void add(Document var1, P var2, MongoCollection<P> var3);

    public abstract P remove(Document var1);

    public abstract boolean canHandle(Document var1);

    public abstract Iterable<P> getPositions(Document var1);

    public abstract long getCount();

    public abstract boolean isEmpty();

    public abstract long getDataSize();

    public abstract void checkUpdate(Document var1, Document var2, MongoCollection<P> var3);

    public abstract void updateInPlace(Document var1, Document var2, MongoCollection<P> var3) throws KeyConstraintError;

    protected boolean isCompoundIndex() {
        return this.keys().size() > 1;
    }

    protected boolean nullAwareEqualsKeys(Document oldDocument, Document newDocument) {
        Set<KeyValue> oldKeyValues = this.getKeyValues(oldDocument);
        Set<KeyValue> newKeyValues = this.getKeyValues(newDocument);
        return Utils.nullAwareEquals(oldKeyValues, newKeyValues);
    }
}

