/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.exception;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.bson.Json;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import java.util.List;
import java.util.stream.Collectors;

public class DuplicateKeyError
extends KeyConstraintError {
    private static final long serialVersionUID = 1L;

    public DuplicateKeyError(Index<?> index, MongoCollection<?> collection, List<?> values) {
        super(11000, "E11000 duplicate key error collection: " + collection.getFullName() + " index: " + index.getName() + " dup key: " + DuplicateKeyError.valuesToString(values));
    }

    private static String valuesToString(List<?> values) {
        return values.stream().map(value -> ": " + Json.toJsonValue(value, true, "{ ", " }")).collect(Collectors.joining(", ", "{ ", " }"));
    }
}

