/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.IndexKey;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Index<P> {
    private final List<IndexKey> keys;

    protected Index(List<IndexKey> keys) {
        this.keys = keys;
    }

    public String getName() {
        if (this.keys.size() == 1 && this.keys.get(0).getKey().equals("_id")) {
            return "_id_";
        }
        return this.keys.stream().map(indexKey -> indexKey.getKey() + "_" + (indexKey.isAscending() ? "1" : "-1")).collect(Collectors.joining("_"));
    }

    protected List<String> keys() {
        return this.keys.stream().map(IndexKey::getKey).collect(Collectors.toList());
    }

    protected Set<String> keySet() {
        return this.keys.stream().map(IndexKey::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    List<Object> getKeyValue(Document document) {
        return this.keys().stream().map(key -> Utils.getSubdocumentValue(document, key)).map(Utils::normalizeValue).collect(Collectors.toList());
    }

    public abstract void checkAdd(Document var1, MongoCollection<P> var2);

    public abstract void add(Document var1, P var2, MongoCollection<P> var3);

    public abstract P remove(Document var1);

    public abstract boolean canHandle(Document var1);

    public abstract Iterable<P> getPositions(Document var1);

    public abstract long getCount();

    public abstract long getDataSize();

    public abstract void checkUpdate(Document var1, Document var2, MongoCollection<P> var3);

    public abstract void updateInPlace(Document var1, Document var2) throws KeyConstraintError;

    protected boolean isCompoundIndex() {
        return this.keys().size() > 1;
    }
}

