/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.tree;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.edgerenderer.EdgeRenderer;
import de.blox.graphview.tree.BuchheimWalkerConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/blox/graphview/tree/TreeEdgeRenderer;", "Lde/blox/graphview/edgerenderer/EdgeRenderer;", "configuration", "Lde/blox/graphview/tree/BuchheimWalkerConfiguration;", "(Lde/blox/graphview/tree/BuchheimWalkerConfiguration;)V", "linePath", "Landroid/graphics/Path;", "render", "", "canvas", "Landroid/graphics/Canvas;", "graph", "Lde/blox/graphview/Graph;", "paint", "Landroid/graphics/Paint;", "graphview_release"})
public final class TreeEdgeRenderer
implements EdgeRenderer {
    private final Path linePath;
    private final BuchheimWalkerConfiguration configuration;

    @Override
    public void render(@NotNull Canvas canvas, @NotNull Graph graph, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        List<Node> nodes = graph.getNodes();
        for (Node node : nodes) {
            List<Node> children = graph.successorsOf(node);
            for (Node child : children) {
                this.linePath.reset();
                switch (this.configuration.getOrientation()) {
                    case 1: {
                        this.linePath.moveTo(child.getX() + (float)child.getWidth() / 2.0f, child.getY());
                        this.linePath.lineTo(child.getX() + (float)child.getWidth() / 2.0f, child.getY() - (float)this.configuration.getLevelSeparation() / 2.0f);
                        this.linePath.lineTo(node.getX() + (float)node.getWidth() / 2.0f, child.getY() - (float)this.configuration.getLevelSeparation() / 2.0f);
                        this.linePath.moveTo(node.getX() + (float)node.getWidth() / 2.0f, child.getY() - (float)this.configuration.getLevelSeparation() / 2.0f);
                        this.linePath.lineTo(node.getX() + (float)node.getWidth() / 2.0f, node.getY() + (float)node.getHeight());
                        break;
                    }
                    case 2: {
                        this.linePath.moveTo(child.getX() + (float)child.getWidth() / 2.0f, child.getY() + (float)child.getHeight());
                        this.linePath.lineTo(child.getX() + (float)child.getWidth() / 2.0f, child.getY() + (float)child.getHeight() + (float)this.configuration.getLevelSeparation() / 2.0f);
                        this.linePath.lineTo(node.getX() + (float)node.getWidth() / 2.0f, child.getY() + (float)child.getHeight() + (float)this.configuration.getLevelSeparation() / 2.0f);
                        this.linePath.moveTo(node.getX() + (float)node.getWidth() / 2.0f, child.getY() + (float)child.getHeight() + (float)this.configuration.getLevelSeparation() / 2.0f);
                        this.linePath.lineTo(node.getX() + (float)node.getWidth() / 2.0f, node.getY() + (float)node.getHeight());
                        break;
                    }
                    case 3: {
                        this.linePath.moveTo(child.getX(), child.getY() + (float)child.getHeight() / 2.0f);
                        this.linePath.lineTo(child.getX() - (float)this.configuration.getLevelSeparation() / 2.0f, child.getY() + (float)child.getHeight() / 2.0f);
                        this.linePath.lineTo(child.getX() - (float)this.configuration.getLevelSeparation() / 2.0f, node.getY() + (float)node.getHeight() / 2.0f);
                        this.linePath.moveTo(child.getX() - (float)this.configuration.getLevelSeparation() / 2.0f, node.getY() + (float)node.getHeight() / 2.0f);
                        this.linePath.lineTo(node.getX() + (float)node.getWidth(), node.getY() + (float)node.getHeight() / 2.0f);
                        break;
                    }
                    case 4: {
                        this.linePath.moveTo(child.getX() + (float)child.getWidth(), child.getY() + (float)child.getHeight() / 2.0f);
                        this.linePath.lineTo(child.getX() + (float)child.getWidth() + (float)this.configuration.getLevelSeparation() / 2.0f, child.getY() + (float)child.getHeight() / 2.0f);
                        this.linePath.lineTo(child.getX() + (float)child.getWidth() + (float)this.configuration.getLevelSeparation() / 2.0f, node.getY() + (float)node.getHeight() / 2.0f);
                        this.linePath.moveTo(child.getX() + (float)child.getWidth() + (float)this.configuration.getLevelSeparation() / 2.0f, node.getY() + (float)node.getHeight() / 2.0f);
                        this.linePath.lineTo(node.getX() + (float)node.getWidth(), node.getY() + (float)node.getHeight() / 2.0f);
                        break;
                    }
                }
                canvas.drawPath(this.linePath, paint);
            }
        }
    }

    public TreeEdgeRenderer(@NotNull BuchheimWalkerConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.linePath = new Path();
    }
}

