/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import de.blox.graphview.GraphAdapter;
import de.blox.graphview.GraphView;
import de.blox.graphview.Layout;
import de.blox.graphview.Node;
import de.blox.graphview.R;
import de.blox.graphview.util.Size;
import de.blox.graphview.util.VectorF;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 J2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0004JKLMB%\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0002J\u0010\u00101\u001a\u00020+2\u0006\u00102\u001a\u000203H\u0014J\u0010\u00104\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J\u0018\u00105\u001a\u00020\t2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0002J\n\u00106\u001a\u0004\u0018\u00010-H\u0016J\u0018\u00107\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u00108\u001a\u00020+2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0002J0\u00109\u001a\u00020+2\u0006\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tH\u0014J\u0018\u0010?\u001a\u00020+2\u0006\u0010@\u001a\u00020\t2\u0006\u0010A\u001a\u00020\tH\u0014J\u0010\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020+H\u0002J\u0018\u0010F\u001a\u00020+2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J\u0010\u0010G\u001a\u00020+2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010H\u001a\u00020+2\u0006\u0010I\u001a\u00020\tH\u0016R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u00020\t2\b\b\u0001\u0010\u000e\u001a\u00020\t8G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001d\u001a\u00020\t2\b\b\u0001\u0010\u000e\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0018\"\u0004\b\u001f\u0010\u001aR\u000e\u0010 \u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'\u00a8\u0006N"}, d2={"Lde/blox/graphview/GraphView;", "Landroid/widget/AdapterView;", "Lde/blox/graphview/GraphAdapter;", "Lde/blox/graphview/GraphView$ViewHolder;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "adapter", "gestureDetector", "Landroid/view/GestureDetector;", "value", "", "isUsingMaxSize", "()Z", "setUsingMaxSize", "(Z)V", "layout", "Lde/blox/graphview/Layout;", "lineColor", "getLineColor", "()I", "setLineColor", "(I)V", "linePaint", "Landroid/graphics/Paint;", "lineThickness", "getLineThickness", "setLineThickness", "maxChildHeight", "maxChildWidth", "observer", "Landroid/database/DataSetObserver;", "rect", "Landroid/graphics/Rect;", "getRect", "()Landroid/graphics/Rect;", "rect$delegate", "Lkotlin/Lazy;", "addAndMeasureChild", "", "child", "Landroid/view/View;", "clickChildAt", "x", "y", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "getAdapter", "getContainingChildIndex", "getSelectedView", "initAttrs", "longClickChildAt", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "positionItems", "setAdapter", "setLayout", "setSelection", "position", "Companion", "GestureListener", "GraphViewObserver", "ViewHolder", "graphview_release"})
public final class GraphView
extends AdapterView<GraphAdapter<ViewHolder>> {
    private Paint linePaint;
    private int lineThickness;
    private int lineColor;
    private boolean isUsingMaxSize;
    private GraphAdapter<ViewHolder> adapter;
    private Layout layout;
    private int maxChildWidth;
    private int maxChildHeight;
    private final Lazy rect$delegate;
    private DataSetObserver observer;
    private final GestureDetector gestureDetector;
    public static final boolean DEFAULT_USE_MAX_SIZE = false;
    public static final int DEFAULT_LINE_THICKNESS = 5;
    public static final int DEFAULT_LINE_COLOR = -16777216;
    public static final int INVALID_INDEX = -1;
    public static final Companion Companion = new Companion(null);

    public final int getLineThickness() {
        return this.lineThickness;
    }

    public final void setLineThickness(@Px int value) {
        this.linePaint.setStrokeWidth((float)value);
        this.lineThickness = value;
        this.invalidate();
    }

    @ColorInt
    public final int getLineColor() {
        return this.lineColor;
    }

    public final void setLineColor(@ColorInt int value) {
        this.linePaint.setColor(value);
        this.lineColor = value;
        this.invalidate();
    }

    public final boolean isUsingMaxSize() {
        return this.isUsingMaxSize;
    }

    public final void setUsingMaxSize(boolean value) {
        this.isUsingMaxSize = value;
        this.invalidate();
        this.requestLayout();
    }

    private final Rect getRect() {
        Lazy lazy = this.rect$delegate;
        GraphView graphView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Rect)lazy.getValue();
    }

    private final void initAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.GraphView, 0, 0);
        this.setLineThickness(a.getDimensionPixelSize(R.styleable.GraphView_lineThickness, 5));
        this.setLineColor(a.getColor(R.styleable.GraphView_lineColor, -16777216));
        this.setUsingMaxSize(a.getBoolean(R.styleable.GraphView_useMaxSize, false));
        a.recycle();
    }

    /*
     * WARNING - void declaration
     */
    private final void positionItems() {
        int maxLeft = Integer.MAX_VALUE;
        int maxRight = Integer.MIN_VALUE;
        int maxTop = Integer.MAX_VALUE;
        int maxBottom = Integer.MIN_VALUE;
        int n = 0;
        GraphAdapter<ViewHolder> graphAdapter = this.adapter;
        if (graphAdapter == null) {
            Intrinsics.throwNpe();
        }
        int n2 = graphAdapter.getCount();
        while (n < n2) {
            void x;
            void index;
            GraphAdapter<ViewHolder> graphAdapter2 = this.adapter;
            if (graphAdapter2 == null) {
                Intrinsics.throwNpe();
            }
            View child = graphAdapter2.getView((int)index, null, (ViewGroup)this);
            this.addAndMeasureChild(child);
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            GraphAdapter<ViewHolder> graphAdapter3 = this.adapter;
            if (graphAdapter3 == null) {
                Intrinsics.throwNpe();
            }
            Object object = graphAdapter3.getItem((int)index);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type de.blox.graphview.Node");
            }
            Node node = (Node)object;
            VectorF vectorF = node.getPosition();
            float f = vectorF.component1();
            float y = vectorF.component2();
            int left = (int)x;
            int top = (int)y;
            int right = left + width;
            int bottom = top + height;
            child.layout(left, top, right, bottom);
            boolean bl = false;
            maxRight = Math.max(maxRight, right);
            bl = false;
            maxLeft = Math.min(maxLeft, left);
            bl = false;
            maxBottom = Math.max(maxBottom, bottom);
            bl = false;
            maxTop = Math.min(maxTop, top);
            ++index;
        }
    }

    private final void addAndMeasureChild(View child) {
        ViewGroup.LayoutParams params = child.getLayoutParams();
        if (params == null) {
            params = new ViewGroup.LayoutParams(-2, -2);
        }
        this.addViewInLayout(child, -1, params, false);
        int widthSpec = GraphView.Companion.makeMeasureSpec(params.width);
        int heightSpec = GraphView.Companion.makeMeasureSpec(params.height);
        if (this.isUsingMaxSize) {
            widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxChildWidth, (int)0x40000000);
            heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxChildHeight, (int)0x40000000);
        }
        child.measure(widthSpec, heightSpec);
    }

    /*
     * WARNING - void declaration
     */
    private final int getContainingChildIndex(int x, int y) {
        int n = 0;
        int n2 = this.getChildCount();
        while (n < n2) {
            void index;
            this.getChildAt((int)index).getHitRect(this.getRect());
            if (this.getRect().contains(x, y)) {
                return (int)index;
            }
            ++index;
        }
        return -1;
    }

    private final void clickChildAt(int x, int y) {
        int index = this.getContainingChildIndex(x, y);
        if (index == -1) {
            return;
        }
        View itemView = this.getChildAt(index);
        GraphAdapter<ViewHolder> graphAdapter = this.adapter;
        if (graphAdapter == null) {
            Intrinsics.throwNpe();
        }
        long id = graphAdapter.getItemId(index);
        this.performItemClick(itemView, index, id);
    }

    private final void longClickChildAt(int x, int y) {
        block2: {
            AdapterView.OnItemLongClickListener listener;
            int index = this.getContainingChildIndex(x, y);
            if (index == -1) {
                return;
            }
            View itemView = this.getChildAt(index);
            GraphAdapter<ViewHolder> graphAdapter = this.adapter;
            if (graphAdapter == null) {
                Intrinsics.throwNpe();
            }
            long id = graphAdapter.getItemId(index);
            AdapterView.OnItemLongClickListener onItemLongClickListener = listener = this.getOnItemLongClickListener();
            if (onItemLongClickListener == null) break block2;
            onItemLongClickListener.onItemLongClick((AdapterView)this, itemView, index, id);
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        return this.gestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.adapter == null) {
            Log.e((String)"GraphView", (String)"No adapter attached; skipping layout");
            return;
        }
        this.removeAllViewsInLayout();
        this.positionItems();
        this.invalidate();
    }

    public final void setLayout(@Nullable Layout layout) {
        if (layout == this.layout) {
            return;
        }
        this.layout = layout;
        this.requestLayout();
    }

    @Nullable
    public View getSelectedView() {
        return null;
    }

    public void setSelection(int position) {
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Adapter adapter;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Adapter adapter2 = adapter = this.getAdapter();
        if (adapter2 != null) {
            Adapter adapter3 = adapter2;
            boolean bl = false;
            boolean bl2 = false;
            Adapter $this$run = adapter3;
            boolean bl3 = false;
            if ($this$run.getGraph().hasNodes()) {
                Layout layout = this.layout;
                if (layout != null) {
                    layout.drawEdges(canvas, $this$run.getGraph(), this.linePaint);
                }
            }
        }
        super.dispatchDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        block10: {
            Size $this$apply;
            boolean bl;
            boolean bl2;
            ViewGroup.MarginLayoutParams params;
            View child;
            int i;
            GraphAdapter<ViewHolder> graphAdapter = this.adapter;
            if (graphAdapter == null) {
                return;
            }
            GraphAdapter<ViewHolder> adapter = graphAdapter;
            if (!adapter.getGraph().hasNodes()) {
                this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
                return;
            }
            int maxWidth = 0;
            int maxHeight = 0;
            int minHeight = Integer.MAX_VALUE;
            int n = 0;
            int n2 = adapter.getCount();
            while (n < n2) {
                child = adapter.getView(i, null, (ViewGroup)this);
                ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) {
                    layoutParams = null;
                }
                if ((params = (ViewGroup.MarginLayoutParams)layoutParams) == null) {
                    params = new ViewGroup.MarginLayoutParams(-2, -2);
                }
                this.addViewInLayout(child, -1, (ViewGroup.LayoutParams)params, true);
                this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
                Object object = adapter.getItem(i);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type de.blox.graphview.Node");
                }
                Node node = (Node)object;
                int measuredWidth = child.getMeasuredWidth();
                int measuredHeight = child.getMeasuredHeight();
                Size size = node.getSize();
                bl2 = false;
                bl = false;
                $this$apply = size;
                boolean bl3 = false;
                $this$apply.setWidth(child.getMeasuredWidth());
                $this$apply.setHeight(child.getMeasuredHeight());
                boolean bl4 = false;
                maxWidth = Math.max(maxWidth, measuredWidth);
                bl4 = false;
                maxHeight = Math.max(maxHeight, measuredHeight);
                bl4 = false;
                minHeight = Math.min(minHeight, measuredHeight);
                ++i;
            }
            this.maxChildWidth = maxWidth;
            this.maxChildHeight = maxHeight;
            if (this.isUsingMaxSize) {
                this.removeAllViewsInLayout();
                n2 = adapter.getCount();
                for (i = 0; i < n2; ++i) {
                    child = adapter.getView(i, null, (ViewGroup)this);
                    params = child.getLayoutParams();
                    if (params == null) {
                        params = new ViewGroup.LayoutParams(-2, -2);
                    }
                    this.addViewInLayout(child, -1, (ViewGroup.LayoutParams)params, true);
                    int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxChildWidth, (int)0x40000000);
                    int heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxChildHeight, (int)0x40000000);
                    child.measure(widthSpec, heightSpec);
                    Object object = adapter.getItem(i);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type de.blox.graphview.Node");
                    }
                    Node node = (Node)object;
                    Size size = node.getSize();
                    bl2 = false;
                    bl = false;
                    $this$apply = size;
                    boolean bl5 = false;
                    $this$apply.setWidth(child.getMeasuredWidth());
                    $this$apply.setHeight(child.getMeasuredHeight());
                }
            }
            adapter.notifyDataSetChanged();
            Layout layout = this.layout;
            if (layout == null) break block10;
            Layout layout2 = layout;
            n2 = 0;
            boolean bl6 = false;
            Layout $this$run = layout2;
            boolean bl7 = false;
            Size size = $this$run.run(adapter.getGraph(), this.getPaddingLeft(), this.getPaddingTop());
            this.setMeasuredDimension(size.getWidth() + this.getPaddingRight() + this.getPaddingLeft(), size.getHeight() + this.getPaddingBottom() + this.getPaddingTop());
        }
    }

    public void setAdapter(@Nullable GraphAdapter<ViewHolder> adapter) {
        block2: {
            GraphAdapter<ViewHolder> oldAdapter;
            GraphAdapter<ViewHolder> graphAdapter = oldAdapter = this.adapter;
            if (graphAdapter != null) {
                graphAdapter.setGraphViewObserver(null);
            }
            this.removeAllViewsInLayout();
            GraphAdapter<ViewHolder> graphAdapter2 = this.adapter = adapter;
            if (graphAdapter2 == null) break block2;
            GraphAdapter<ViewHolder> graphAdapter3 = graphAdapter2;
            boolean bl = false;
            boolean bl2 = false;
            GraphAdapter<ViewHolder> it = graphAdapter3;
            boolean bl3 = false;
            if (this.observer == null) {
                this.observer = new GraphViewObserver();
            }
            it.setGraphViewObserver(this.observer);
            this.requestLayout();
        }
    }

    @Nullable
    public GraphAdapter<ViewHolder> getAdapter() {
        return this.adapter;
    }

    @JvmOverloads
    public GraphView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        Paint paint2 = new Paint(1);
        GraphView graphView = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        $this$apply.setStrokeWidth((float)this.lineThickness);
        $this$apply.setColor(this.lineColor);
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setStrokeJoin(Paint.Join.ROUND);
        $this$apply.setPathEffect((PathEffect)new CornerPathEffect(10.0f));
        graphView.linePaint = paint = paint2;
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            paint2 = attributeSet;
            bl = false;
            bl2 = false;
            Paint it = paint2;
            boolean bl4 = false;
            this.initAttrs(context, (AttributeSet)it);
        }
        this.lineThickness = 5;
        this.lineColor = -16777216;
        this.rect$delegate = LazyKt.lazy((Function0)rect.2.INSTANCE);
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureListener());
    }

    public /* synthetic */ GraphView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public GraphView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GraphView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lde/blox/graphview/GraphView$GestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "(Lde/blox/graphview/GraphView;)V", "onDown", "", "e", "Landroid/view/MotionEvent;", "onLongPress", "", "onSingleTapUp", "graphview_release"})
    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onDown(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return true;
        }

        public boolean onSingleTapUp(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            GraphView.this.clickChildAt((int)e.getX(), (int)e.getY());
            return true;
        }

        public void onLongPress(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            GraphView.this.longClickChildAt((int)e.getX(), (int)e.getY());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"Lde/blox/graphview/GraphView$GraphViewObserver;", "Landroid/database/DataSetObserver;", "(Lde/blox/graphview/GraphView;)V", "onChanged", "", "onInvalidated", "refresh", "graphview_release"})
    private final class GraphViewObserver
    extends DataSetObserver {
        public void onChanged() {
            this.refresh();
        }

        public void onInvalidated() {
            this.refresh();
        }

        private final void refresh() {
            GraphView.this.requestLayout();
            GraphView.this.invalidate();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/blox/graphview/GraphView$ViewHolder;", "", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "getItemView", "()Landroid/view/View;", "graphview_release"})
    public static abstract class ViewHolder {
        @NotNull
        private final View itemView;

        @NotNull
        public final View getItemView() {
            return this.itemView;
        }

        public ViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            this.itemView = itemView;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/blox/graphview/GraphView$Companion;", "", "()V", "DEFAULT_LINE_COLOR", "", "DEFAULT_LINE_THICKNESS", "DEFAULT_USE_MAX_SIZE", "", "INVALID_INDEX", "makeMeasureSpec", "dimension", "graphview_release"})
    public static final class Companion {
        private final int makeMeasureSpec(int dimension) {
            return dimension > 0 ? View.MeasureSpec.makeMeasureSpec((int)dimension, (int)0x40000000) : 0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

