/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.energy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import de.blox.graphview.Algorithm;
import de.blox.graphview.Edge;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.Size;
import de.blox.graphview.Vector;
import de.blox.graphview.edgerenderer.ArrowEdgeRenderer;
import de.blox.graphview.edgerenderer.EdgeRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class FruchtermanReingoldAlgorithm
implements Algorithm {
    public static final int DEFAULT_ITERATIONS = 1000;
    public static final int CLUSTER_PADDING = 100;
    private static final double EPSILON = 1.0E-4;
    private static final long SEED = 401678L;
    private final int iterations;
    private EdgeRenderer edgeRenderer = new ArrowEdgeRenderer();
    private Map<Node, Vector> disps = new HashMap<Node, Vector>();
    private Random rand = new Random(401678L);
    private int width;
    private int height;
    private float k;
    private float t;
    private float attraction_k;
    private float repulsion_k;
    private Size size = new Size(0, 0);

    public FruchtermanReingoldAlgorithm() {
        this(1000);
    }

    public FruchtermanReingoldAlgorithm(int iterations) {
        this.iterations = iterations;
    }

    private static int randInt(Random rand, int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    private void randomize(List<Node> nodes) {
        for (Node node : nodes) {
            this.disps.put(node, new Vector());
            node.setPos(new Vector(FruchtermanReingoldAlgorithm.randInt(this.rand, 0, this.width / 2), FruchtermanReingoldAlgorithm.randInt(this.rand, 0, this.height / 2)));
        }
    }

    private void cool(int currentIteration) {
        this.t = (float)((double)this.t * (1.0 - (double)currentIteration / (double)this.iterations));
    }

    private void limitMaximumDisplacement(List<Node> nodes) {
        for (Node v : nodes) {
            float dispLength = (float)Math.max(1.0E-4, (double)this.getDisp(v).length());
            v.setPos(v.getPosition().add(this.getDisp(v).divide(dispLength).multiply(Math.min(dispLength, this.t))));
        }
    }

    private void calculateAttraction(List<Edge> edges) {
        for (Edge e : edges) {
            Node v = e.getSource();
            Node u = e.getDestination();
            Vector delta = v.getPosition().subtract(u.getPosition());
            float deltaLength = (float)Math.max(1.0E-4, (double)delta.length());
            this.setDisp(v, this.getDisp(v).subtract(delta.divide(deltaLength).multiply(this.forceAttraction(deltaLength))));
            this.setDisp(u, this.getDisp(u).add(delta.divide(deltaLength).multiply(this.forceAttraction(deltaLength))));
        }
    }

    private void calculateRepulsion(List<Node> nodes) {
        for (Node v : nodes) {
            for (Node u : nodes) {
                if (u.equals(v)) continue;
                Vector delta = v.getPosition().subtract(u.getPosition());
                float deltaLength = (float)Math.max(1.0E-4, (double)delta.length());
                this.setDisp(v, this.getDisp(v).add(delta.divide(deltaLength).multiply(this.forceRepulsion(deltaLength))));
            }
        }
    }

    private float forceAttraction(float x) {
        return x * x / this.attraction_k;
    }

    private float forceRepulsion(float x) {
        return this.repulsion_k * this.repulsion_k / x;
    }

    private Vector getDisp(Node node) {
        return this.disps.get(node);
    }

    private void setDisp(Node node, Vector disp) {
        this.disps.put(node, disp);
    }

    @Override
    public void run(Graph graph) {
        int size;
        this.width = size = this.findBiggestSize(graph) * graph.getNodeCount();
        this.height = size;
        List<Node> nodes = graph.getNodes();
        List<Edge> edges = graph.getEdges();
        this.t = (float)(0.1 * Math.sqrt(this.width / 2 * this.height / 2));
        this.k = (float)(0.75 * Math.sqrt(this.width * this.height / nodes.size()));
        this.attraction_k = 0.75f * this.k;
        this.repulsion_k = 0.75f * this.k;
        this.randomize(nodes);
        for (int i = 0; i < this.iterations; ++i) {
            this.calculateRepulsion(nodes);
            this.calculateAttraction(edges);
            this.limitMaximumDisplacement(nodes);
            this.cool(i);
            if (this.done()) break;
        }
        this.positionNodes(graph);
        this.calculateGraphSize(graph);
    }

    private void positionNodes(Graph graph) {
        Vector offset = this.getOffset(graph);
        ArrayList<Node> nodesVisited = new ArrayList<Node>();
        ArrayList<NodeCluster> nodeClusters = new ArrayList<NodeCluster>();
        for (Node node : graph.getNodes()) {
            node.setPos(new Vector(node.getX() - offset.getX(), node.getY() - offset.getY()));
        }
        for (Node node : graph.getNodes()) {
            if (nodesVisited.contains(node)) continue;
            nodesVisited.add(node);
            NodeCluster cluster = this.findClusterOf(nodeClusters, node);
            if (cluster == null) {
                cluster = new NodeCluster();
                cluster.add(node);
                nodeClusters.add(cluster);
            }
            this.followEdges(graph, cluster, node, nodesVisited);
        }
        this.positionCluster(nodeClusters);
    }

    private void positionCluster(List<NodeCluster> nodeClusters) {
        this.combineSingleNodeCluster(nodeClusters);
        NodeCluster cluster = nodeClusters.get(0);
        cluster.offset(-((NodeCluster)cluster).rect.left, -((NodeCluster)cluster).rect.top);
        for (int i = 1; i < nodeClusters.size(); ++i) {
            NodeCluster nextCluster = nodeClusters.get(i);
            float xDiff = ((NodeCluster)nextCluster).rect.left - ((NodeCluster)cluster).rect.right - 100.0f;
            float yDiff = ((NodeCluster)nextCluster).rect.top - ((NodeCluster)cluster).rect.top;
            nextCluster.offset(-xDiff, -yDiff);
            cluster = nextCluster;
        }
    }

    private void combineSingleNodeCluster(List<NodeCluster> nodeClusters) {
        NodeCluster firstSingleNodeCluster = null;
        Iterator<NodeCluster> iterator = nodeClusters.iterator();
        while (iterator.hasNext()) {
            NodeCluster cluster = iterator.next();
            if (cluster.size() != 1) continue;
            if (firstSingleNodeCluster == null) {
                firstSingleNodeCluster = cluster;
                continue;
            }
            firstSingleNodeCluster.concat(cluster);
            iterator.remove();
        }
    }

    private void followEdges(Graph graph, NodeCluster cluster, Node node, List<Node> nodesVisited) {
        for (Node successor : graph.successorsOf(node)) {
            if (nodesVisited.contains(successor)) continue;
            nodesVisited.add(successor);
            cluster.add(successor);
            this.followEdges(graph, cluster, successor, nodesVisited);
        }
        for (Node predecessor : graph.predecessorsOf(node)) {
            if (nodesVisited.contains(predecessor)) continue;
            nodesVisited.add(predecessor);
            cluster.add(predecessor);
            this.followEdges(graph, cluster, predecessor, nodesVisited);
        }
    }

    private NodeCluster findClusterOf(List<NodeCluster> clusters, Node node) {
        for (NodeCluster cluster : clusters) {
            if (!cluster.contains(node)) continue;
            return cluster;
        }
        return null;
    }

    private int findBiggestSize(Graph graph) {
        int size = 0;
        for (Node node : graph.getNodes()) {
            size = Math.max(size, Math.max(node.getHeight(), node.getWidth()));
        }
        return size;
    }

    private Vector getOffset(Graph graph) {
        float offsetX = Float.MAX_VALUE;
        float offsetY = Float.MAX_VALUE;
        for (Node node : graph.getNodes()) {
            offsetX = Math.min(offsetX, node.getX());
            offsetY = Math.min(offsetY, node.getY());
        }
        return new Vector(offsetX, offsetY);
    }

    private boolean done() {
        return (double)this.t < 1.0 / (double)Math.max(this.height, this.width);
    }

    @Override
    public void drawEdges(Canvas canvas, Graph graph, Paint linePaint) {
        this.edgeRenderer.render(canvas, graph, linePaint);
    }

    @Override
    public void setEdgeRenderer(EdgeRenderer renderer) {
        this.edgeRenderer = renderer;
    }

    @Override
    public Size getGraphSize() {
        return this.size;
    }

    private void calculateGraphSize(Graph graph) {
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        for (Node node : graph.getNodes()) {
            left = (int)Math.min((float)left, node.getX());
            top = (int)Math.min((float)top, node.getY());
            right = (int)Math.max((float)right, node.getX() + (float)node.getWidth());
            bottom = (int)Math.max((float)bottom, node.getY() + (float)node.getHeight());
        }
        this.size = new Size(right - left, bottom - top);
    }

    private static class NodeCluster {
        private List<Node> nodes = new ArrayList<Node>();
        private RectF rect;

        private NodeCluster() {
        }

        public void add(Node node) {
            this.nodes.add(node);
            if (this.rect == null) {
                this.rect = new RectF(node.getX(), node.getY(), node.getX() + (float)node.getWidth(), node.getY() + (float)node.getHeight());
            } else {
                this.rect.left = Math.min(this.rect.left, node.getX());
                this.rect.top = Math.min(this.rect.top, node.getY());
                this.rect.right = Math.max(this.rect.right, node.getX() + (float)node.getWidth());
                this.rect.bottom = Math.max(this.rect.bottom, node.getY() + (float)node.getHeight());
            }
        }

        public boolean contains(Node node) {
            return this.nodes.contains(node);
        }

        public int size() {
            return this.nodes.size();
        }

        public void concat(NodeCluster cluster) {
            for (Node node : cluster.nodes) {
                node.setPos(new Vector(this.rect.right + 100.0f, this.rect.top));
                this.add(node);
            }
        }

        public void offset(float xDiff, float yDiff) {
            for (Node node : this.nodes) {
                node.setPos(node.getPosition().add(xDiff, yDiff));
            }
            this.rect.offset(xDiff, yDiff);
        }
    }
}

