/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.edgerenderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import de.blox.graphview.Edge;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.Vector;
import de.blox.graphview.edgerenderer.EdgeRenderer;

public class ArrowEdgeRenderer
implements EdgeRenderer {
    private static final float ARROW_DEGREES = 0.5f;
    private static final float ARROW_LENGTH = 50.0f;
    private Path trianglePath = new Path();

    @Override
    public void render(Canvas canvas, Graph graph, Paint paint) {
        Paint trianglePaint = new Paint(paint);
        trianglePaint.setStyle(Paint.Style.FILL);
        for (Edge edge : graph.getEdges()) {
            Node source = edge.getSource();
            Vector sourcePosition = source.getPosition();
            Node destination = edge.getDestination();
            Vector destinationPosition = destination.getPosition();
            float startX = sourcePosition.getX() + (float)source.getWidth() / 2.0f;
            float startY = sourcePosition.getY() + (float)source.getHeight() / 2.0f;
            float stopX = destinationPosition.getX() + (float)destination.getWidth() / 2.0f;
            float stopY = destinationPosition.getY() + (float)destination.getHeight() / 2.0f;
            float[] clippedLine = this.clipLine(startX, startY, stopX, stopY, destination);
            float[] triangleCentroid = this.drawTriangle(canvas, trianglePaint, clippedLine[0], clippedLine[1], clippedLine[2], clippedLine[3]);
            canvas.drawLine(clippedLine[0], clippedLine[1], triangleCentroid[0], triangleCentroid[1], paint);
        }
    }

    protected float[] clipLine(float startX, float startY, float stopX, float stopY, Node destination) {
        float[] resultLine = new float[4];
        resultLine[0] = startX;
        resultLine[1] = startY;
        float slope = (startY - stopY) / (startX - stopX);
        float halfHeight = (float)destination.getHeight() / 2.0f;
        float halfWidth = (float)destination.getWidth() / 2.0f;
        float halfSlopeWidth = slope * halfWidth;
        float halfSlopeHeight = halfHeight / slope;
        if (-halfHeight <= halfSlopeWidth && halfSlopeWidth <= halfHeight) {
            if (destination.getX() > startX) {
                resultLine[2] = stopX - halfWidth;
                resultLine[3] = stopY - halfSlopeWidth;
            } else if (destination.getX() < startX) {
                resultLine[2] = stopX + halfWidth;
                resultLine[3] = stopY + halfSlopeWidth;
            }
        }
        if (-halfWidth <= halfSlopeHeight && halfSlopeHeight <= halfWidth) {
            if (destination.getY() < startY) {
                resultLine[2] = stopX + halfSlopeHeight;
                resultLine[3] = stopY + halfHeight;
            } else if (destination.getY() > startY) {
                resultLine[2] = stopX - halfSlopeHeight;
                resultLine[3] = stopY - halfHeight;
            }
        }
        return resultLine;
    }

    protected float[] drawTriangle(Canvas canvas, Paint paint, float x1, float y1, float x2, float y2) {
        float angle = (float)(Math.atan2(y2 - y1, x2 - x1) + Math.PI);
        float x3 = (float)((double)x2 + 50.0 * Math.cos(angle - 0.5f));
        float y3 = (float)((double)y2 + 50.0 * Math.sin(angle - 0.5f));
        float x4 = (float)((double)x2 + 50.0 * Math.cos(angle + 0.5f));
        float y4 = (float)((double)y2 + 50.0 * Math.sin(angle + 0.5f));
        this.trianglePath.moveTo(x2, y2);
        this.trianglePath.lineTo(x3, y3);
        this.trianglePath.lineTo(x4, y4);
        this.trianglePath.close();
        canvas.drawPath(this.trianglePath, paint);
        float x = (x2 + x3 + x4) / 3.0f;
        float y = (y2 + y3 + y4) / 3.0f;
        float[] triangleCentroid = new float[]{x, y};
        this.trianglePath.reset();
        return triangleCentroid;
    }
}

