/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.layered;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.annimon.stream.Stream;
import de.blox.graphview.Algorithm;
import de.blox.graphview.Edge;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.Size;
import de.blox.graphview.edgerenderer.EdgeRenderer;
import de.blox.graphview.layered.SugiyamaConfiguration;
import de.blox.graphview.layered.SugiyamaEdgeData;
import de.blox.graphview.layered.SugiyamaEdgeRenderer;
import de.blox.graphview.layered.SugiyamaNodeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SugiyamaAlgorithm
implements Algorithm {
    private final SugiyamaConfiguration configuration;
    private Map<Node, SugiyamaNodeData> nodeData = new HashMap<Node, SugiyamaNodeData>();
    private Map<Edge, SugiyamaEdgeData> edgeData = new HashMap<Edge, SugiyamaEdgeData>();
    private Set<Node> stack = new HashSet<Node>();
    private Set<Node> visited = new HashSet<Node>();
    private List<List<Node>> layers = new ArrayList<List<Node>>();
    private Graph graph;
    private EdgeRenderer edgeRenderer;
    private Size size;
    private int nodeCount = 1;

    public SugiyamaAlgorithm(SugiyamaConfiguration configuration) {
        this.configuration = configuration;
        this.edgeRenderer = new SugiyamaEdgeRenderer(this.edgeData);
    }

    @Override
    public void run(Graph graph) {
        this.graph = this.copyGraph(graph);
        this.reset();
        this.initSugiymaData();
        this.cycleRemoval();
        this.layerAssignment();
        this.nodeOrdering();
        this.coordinateAssignment();
        this.calculateGraphSize(this.graph);
        this.denormalize();
        this.restoreCycle();
    }

    private void calculateGraphSize(Graph graph) {
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        for (Node node : graph.getNodes()) {
            left = (int)Math.min((float)left, node.getX());
            top = (int)Math.min((float)top, node.getY());
            right = (int)Math.max((float)right, node.getX() + (float)node.getWidth());
            bottom = (int)Math.max((float)bottom, node.getY() + (float)node.getHeight());
        }
        this.size = new Size(right - left, bottom - top);
    }

    private void reset() {
        this.layers.clear();
        this.stack.clear();
        this.visited.clear();
        this.nodeData.clear();
        this.edgeData.clear();
        this.nodeCount = 1;
    }

    private void initSugiymaData() {
        for (Node node : this.graph.getNodes()) {
            node.setX(0.0f);
            node.setY(0.0f);
            this.nodeData.put(node, new SugiyamaNodeData());
        }
        for (Edge edge : this.graph.getEdges()) {
            this.edgeData.put(edge, new SugiyamaEdgeData());
        }
    }

    private void cycleRemoval() {
        for (Node node : this.graph.getNodes()) {
            this.dfs(node);
        }
    }

    private void dfs(Node node) {
        if (this.visited.contains(node)) {
            return;
        }
        this.visited.add(node);
        this.stack.add(node);
        for (Edge edge : this.graph.getOutEdges(node)) {
            Node target = edge.getDestination();
            if (this.stack.contains(target)) {
                this.graph.removeEdge(edge);
                this.graph.addEdge(target, node);
                this.nodeData.get((Object)node).reversed = true;
                continue;
            }
            this.dfs(target);
        }
        this.stack.remove(node);
    }

    private void layerAssignment() {
        if (this.graph.getNodes().isEmpty()) {
            return;
        }
        Graph copyGraph = this.copyGraph(this.graph);
        List<Node> roots = this.getRootNodes(copyGraph);
        while (roots.size() > 0) {
            this.layers.add(roots);
            copyGraph.removeNodes(roots.toArray(new Node[roots.size()]));
            roots = this.getRootNodes(copyGraph);
        }
        for (int i = 0; i < this.layers.size() - 1; ++i) {
            int indexNextLayer = i + 1;
            List<Node> currentLayer = this.layers.get(i);
            List<Node> nextLayer = this.layers.get(indexNextLayer);
            for (Node node : currentLayer) {
                List edges = Stream.ofNullable(this.graph.getEdges()).filter(e -> e.getSource().equals(node)).filter(e -> Math.abs(this.nodeData.get((Object)e.getDestination()).layer - this.nodeData.get((Object)node).layer) > 1).toList();
                Iterator iterator = edges.iterator();
                while (iterator.hasNext()) {
                    Edge edge = (Edge)iterator.next();
                    Node dummy = new Node(this.getDummyText());
                    SugiyamaNodeData dummyNodeData = new SugiyamaNodeData();
                    dummyNodeData.dummy = true;
                    dummyNodeData.layer = indexNextLayer;
                    nextLayer.add(dummy);
                    this.nodeData.put(dummy, dummyNodeData);
                    dummy.setSize(edge.getSource().getWidth(), 0);
                    Edge dummyEdge1 = this.graph.addEdge(edge.getSource(), dummy);
                    Edge dummyEdge2 = this.graph.addEdge(dummy, edge.getDestination());
                    this.edgeData.put(dummyEdge1, new SugiyamaEdgeData());
                    this.edgeData.put(dummyEdge2, new SugiyamaEdgeData());
                    this.graph.removeEdge(edge);
                    iterator.remove();
                }
            }
        }
    }

    private List<Node> getRootNodes(Graph graph) {
        ArrayList<Node> roots = new ArrayList<Node>();
        for (Node node : graph.getNodes()) {
            int inDegree = 0;
            for (Edge edge : graph.getEdges()) {
                if (!edge.getDestination().equals(node)) continue;
                ++inDegree;
            }
            if (inDegree != 0) continue;
            roots.add(node);
            this.nodeData.get((Object)node).layer = this.layers.size();
        }
        return roots;
    }

    private Graph copyGraph(Graph graph) {
        Graph copy = new Graph();
        copy.addNodes(graph.getNodes().toArray(new Node[graph.getNodes().size()]));
        copy.addEdges(graph.getEdges().toArray(new Edge[graph.getEdges().size()]));
        return copy;
    }

    private void nodeOrdering() {
        ArrayList<List<Node>> best = new ArrayList<List<Node>>(this.layers);
        for (int i = 0; i < 24; ++i) {
            this.median(best, i);
            this.transpose(best);
            if (this.crossing(best) >= this.crossing(this.layers)) continue;
            this.layers = best;
        }
    }

    private void median(List<List<Node>> layers, int currentIteration) {
        if (currentIteration % 2 == 0) {
            for (int i = 1; i < layers.size(); ++i) {
                List<Node> currentLayer = layers.get(i);
                List<Node> previousLayer = layers.get(i - 1);
                for (Node node : currentLayer) {
                    int right;
                    List positions = Stream.of(this.graph.getEdges()).filter(edge -> previousLayer.contains(edge.getSource())).map(edge -> previousLayer.indexOf(edge.getSource())).toList();
                    Collections.sort(positions);
                    int median = positions.size() / 2;
                    if (positions.isEmpty()) continue;
                    if (positions.size() == 1) {
                        this.nodeData.get((Object)node).median = -1;
                        continue;
                    }
                    if (positions.size() == 2) {
                        this.nodeData.get((Object)node).median = ((Integer)positions.get(0) + (Integer)positions.get(1)) / 2;
                        continue;
                    }
                    if (positions.size() % 2 == 1) {
                        this.nodeData.get((Object)node).median = (Integer)positions.get(median);
                        continue;
                    }
                    int left = (Integer)positions.get(median - 1) - (Integer)positions.get(0);
                    if (left + (right = (Integer)positions.get(positions.size() - 1) - (Integer)positions.get(median)) == 0) continue;
                    this.nodeData.get((Object)node).median = ((Integer)positions.get(median - 1) * right + (Integer)positions.get(median) * left) / (left + right);
                }
                Collections.sort(currentLayer, (n1, n2) -> {
                    SugiyamaNodeData nodeData1 = this.nodeData.get(n1);
                    SugiyamaNodeData nodeData2 = this.nodeData.get(n2);
                    return nodeData1.median - nodeData2.median;
                });
            }
        } else {
            for (int l = 1; l < layers.size(); ++l) {
                List<Node> currentLayer = layers.get(l);
                List<Node> previousLayer = layers.get(l - 1);
                for (int i = currentLayer.size() - 1; i > 0; --i) {
                    Node node = currentLayer.get(i);
                    List positions = Stream.of(this.graph.getEdges()).filter(edge -> previousLayer.contains(edge.getSource())).map(edge -> previousLayer.indexOf(edge.getSource())).toList();
                    Collections.sort(positions);
                    if (positions.isEmpty()) continue;
                    this.nodeData.get((Object)node).median = positions.size() == 1 ? (Integer)positions.get(0) : ((Integer)positions.get((int)Math.ceil((double)positions.size() / 2.0)) + (Integer)positions.get((int)Math.ceil((double)positions.size() / 2.0) - 1)) / 2;
                }
                Collections.sort(currentLayer, (n1, n2) -> {
                    SugiyamaNodeData nodeData1 = this.nodeData.get(n1);
                    SugiyamaNodeData nodeData2 = this.nodeData.get(n2);
                    return nodeData1.median - nodeData2.median;
                });
            }
        }
    }

    private void transpose(List<List<Node>> layers) {
        boolean improved = true;
        while (improved) {
            improved = false;
            for (int l = 0; l < layers.size() - 1; ++l) {
                List<Node> northernNodes = layers.get(l);
                List<Node> southernNodes = layers.get(l + 1);
                for (int i = 0; i < southernNodes.size() - 1; ++i) {
                    Node w;
                    Node v = southernNodes.get(i);
                    if (this.crossing(northernNodes, v, w = southernNodes.get(i + 1)) <= this.crossing(northernNodes, w, v)) continue;
                    improved = true;
                    this.exchange(southernNodes, v, w);
                }
            }
        }
    }

    private void exchange(List<Node> nodes, Node v, Node w) {
        Collections.swap(nodes, nodes.indexOf(v), nodes.indexOf(w));
    }

    private int crossing(List<Node> northernNodes, Node n1, Node n2) {
        int crossing = 0;
        List parentNodesN1 = Stream.ofNullable(this.graph.getEdges()).filter(edge -> edge.getDestination().equals(n1)).map(Edge::getSource).toList();
        List parentNodesN2 = Stream.ofNullable(this.graph.getEdges()).filter(edge -> edge.getDestination().equals(n2)).map(Edge::getSource).toList();
        for (Node pn2 : parentNodesN2) {
            int indexOfPn2 = northernNodes.indexOf(pn2);
            for (Node pn1 : parentNodesN1) {
                if (indexOfPn2 >= northernNodes.indexOf(pn1)) continue;
                ++crossing;
            }
        }
        return crossing;
    }

    private int crossing(List<List<Node>> layers) {
        int crossing = 0;
        for (int l = 0; l < layers.size() - 1; ++l) {
            List<Node> southernNodes = layers.get(l);
            List<Node> northernNodes = layers.get(l + 1);
            for (int i = 0; i < southernNodes.size() - 2; ++i) {
                Node v = southernNodes.get(i);
                Node w = southernNodes.get(i + 1);
                crossing += this.crossing(northernNodes, v, w);
            }
        }
        return crossing;
    }

    private void coordinateAssignment() {
        this.assignX();
        this.assignY();
    }

    private void assignX() {
        ArrayList root = new ArrayList(4);
        ArrayList align = new ArrayList(4);
        ArrayList sink = new ArrayList(4);
        ArrayList<HashMap<Node, Float>> x = new ArrayList<HashMap<Node, Float>>(4);
        ArrayList shift = new ArrayList(4);
        ArrayList<HashMap<Node, Float>> blockWidth = new ArrayList<HashMap<Node, Float>>(4);
        for (int i = 0; i < 4; ++i) {
            root.add(new HashMap());
            align.add(new HashMap());
            sink.add(new HashMap());
            shift.add(new HashMap());
            x.add(new HashMap());
            blockWidth.add(new HashMap());
            for (Node n : this.graph.getNodes()) {
                ((HashMap)root.get(i)).put(n, n);
                ((HashMap)align.get(i)).put(n, n);
                ((HashMap)sink.get(i)).put(n, n);
                ((HashMap)shift.get(i)).put(n, Float.valueOf(Float.MAX_VALUE));
                ((HashMap)x.get(i)).put(n, Float.valueOf(Float.MIN_VALUE));
                ((HashMap)blockWidth.get(i)).put(n, Float.valueOf(0.0f));
            }
        }
        for (int downward = 0; downward <= 1; ++downward) {
            List<List<Boolean>> type1Conflicts = this.markType1Conflicts(downward == 0);
            for (int leftToRight = 0; leftToRight <= 1; ++leftToRight) {
                int k = 2 * downward + leftToRight;
                this.verticalAlignment((HashMap)root.get(k), (HashMap)align.get(k), type1Conflicts, downward == 0, leftToRight == 0);
                this.computeBlockWidths((HashMap)root.get(k), (HashMap)blockWidth.get(k));
                this.horizontalCompactation((HashMap)align.get(k), (HashMap)root.get(k), (HashMap)sink.get(k), (HashMap)shift.get(k), (HashMap)blockWidth.get(k), (HashMap)x.get(k), leftToRight == 0, downward == 0);
            }
        }
        this.balance(x, blockWidth);
        System.out.println("bla");
    }

    private void balance(List<HashMap<Node, Float>> x, List<HashMap<Node, Float>> blockWidth) {
        int i;
        HashMap<Node, Float> coordinates = new HashMap<Node, Float>();
        float minWidth = Float.MAX_VALUE;
        int smallestWidthLayout = 0;
        float[] min = new float[4];
        float[] max = new float[4];
        for (int i2 = 0; i2 <= 3; ++i2) {
            min[i2] = 2.1474836E9f;
            max[i2] = 0.0f;
            for (Node node : this.graph.getNodes()) {
                float bw = 0.5f * blockWidth.get(i2).get(node).floatValue();
                float xp = x.get(i2).get(node).floatValue() - bw;
                if (xp < min[i2]) {
                    min[i2] = xp;
                }
                if (!((xp = x.get(i2).get(node).floatValue() + bw) > max[i2])) continue;
                max[i2] = xp;
            }
            float width = max[i2] - min[i2];
            if (!(width < minWidth)) continue;
            minWidth = width;
            smallestWidthLayout = i2;
        }
        for (int i2 = 0; i2 <= 3; ++i2) {
            float diff;
            if (i2 == smallestWidthLayout) continue;
            if (i2 == 0 || i2 == 1) {
                diff = min[i2] - min[smallestWidthLayout];
                for (Node n : x.get(i2).keySet()) {
                    if (diff > 0.0f) {
                        x.get(i2).put(n, Float.valueOf(x.get(i2).get(n).floatValue() - diff));
                        continue;
                    }
                    x.get(i2).put(n, Float.valueOf(x.get(i2).get(n).floatValue() + diff));
                }
                continue;
            }
            diff = max[i2] - max[smallestWidthLayout];
            for (Node n : x.get(i2).keySet()) {
                if (diff > 0.0f) {
                    x.get(i2).put(n, Float.valueOf(x.get(i2).get(n).floatValue() - diff));
                    continue;
                }
                x.get(i2).put(n, Float.valueOf(x.get(i2).get(n).floatValue() + diff));
            }
        }
        float minValue = Float.MAX_VALUE;
        for (i = 0; i <= 3; ++i) {
            for (float xVal : x.get(i).values()) {
                if (!(xVal < minValue)) continue;
                minValue = xVal;
            }
        }
        if (minValue != 0.0f) {
            for (i = 0; i <= 3; ++i) {
                for (Node n : x.get(i).keySet()) {
                    x.get(i).put(n, Float.valueOf(x.get(i).get(n).floatValue() - minValue));
                }
            }
        }
        for (Node node : this.graph.getNodes()) {
            float[] values = new float[4];
            for (int i3 = 0; i3 < 4; ++i3) {
                values[i3] = x.get(i3).get(node).floatValue();
            }
            Arrays.sort(values);
            float average = (values[1] + values[2]) / 2.0f;
            coordinates.put(node, Float.valueOf(average));
        }
        minValue = 2.1474836E9f;
        Iterator<Node> iterator = coordinates.values().iterator();
        while (iterator.hasNext()) {
            float f = ((Float)((Object)iterator.next())).floatValue();
            if (!(f < minValue)) continue;
            minValue = f;
        }
        if (minValue != 0.0f) {
            for (Node node : coordinates.keySet()) {
                coordinates.put(node, Float.valueOf(((Float)coordinates.get(node)).floatValue() - minValue));
            }
        }
        for (Node node : this.graph.getNodes()) {
            node.setX(((Float)coordinates.get(node)).floatValue());
        }
    }

    private List<List<Boolean>> markType1Conflicts(boolean downward) {
        ArrayList<List<Boolean>> type1Conflicts = new ArrayList<List<Boolean>>();
        for (int i = 0; i < this.graph.getNodes().size(); ++i) {
            type1Conflicts.add(new ArrayList());
            for (int l = 0; l < this.graph.getEdges().size(); ++l) {
                ((List)type1Conflicts.get(i)).add(false);
            }
        }
        if (this.layers.size() >= 4) {
            int upper;
            int lower;
            if (downward) {
                lower = 1;
                upper = this.layers.size() - 2;
            } else {
                lower = this.layers.size() - 1;
                upper = 2;
            }
            int i = lower;
            while (downward && i <= upper || !downward && i >= upper) {
                int k0 = 0;
                int firstIndex = 0;
                List<Node> currentLevel = this.layers.get(i);
                List<Node> nextLevel = downward ? this.layers.get(i + 1) : this.layers.get(i - 1);
                for (int l1 = 0; l1 <= nextLevel.size() - 1; ++l1) {
                    Node virtualTwin = this.virtualTwinNode(nextLevel.get(l1), downward);
                    if (l1 != nextLevel.size() - 1 && virtualTwin == null) continue;
                    int k1 = currentLevel.size() - 1;
                    if (virtualTwin != null) {
                        k1 = this.pos(virtualTwin);
                    }
                    while (firstIndex <= l1) {
                        List<Node> upperNeighbours = this.getAdjNodes(nextLevel.get(l1), downward);
                        for (Node currentNeighbour : upperNeighbours) {
                            int currentNeighbourIndex = this.pos(currentNeighbour);
                            if (currentNeighbourIndex >= k0 && currentNeighbourIndex <= k1) continue;
                            ((List)type1Conflicts.get(l1)).set(currentNeighbourIndex, true);
                        }
                        ++firstIndex;
                    }
                    k0 = k1;
                }
                i = downward ? i + 1 : i - 1;
            }
        }
        return type1Conflicts;
    }

    private void verticalAlignment(HashMap<Node, Node> root, HashMap<Node, Node> align, List<List<Boolean>> type1Conflicts, boolean downward, boolean leftToRight) {
        int i;
        int n = i = downward ? 0 : this.layers.size() - 1;
        while (downward && i <= this.layers.size() - 1 || !downward && i >= 0) {
            int k;
            List<Node> currentLevel = this.layers.get(i);
            int r = leftToRight ? -1 : Integer.MAX_VALUE;
            int n2 = k = leftToRight ? 0 : currentLevel.size() - 1;
            while (leftToRight && k <= currentLevel.size() - 1 || !leftToRight && k >= 0) {
                Node v = currentLevel.get(k);
                List<Node> adjNodes = this.getAdjNodes(v, downward);
                if (adjNodes.size() > 0) {
                    int median = (int)Math.floor((double)(adjNodes.size() + 1) / 2.0);
                    int medianCount = adjNodes.size() % 2 == 1 ? 1 : 2;
                    for (int count = 0; count < medianCount; ++count) {
                        Node m = adjNodes.get(median + count - 1);
                        int posM = this.pos(m);
                        if (!align.get(v).equals(v) || type1Conflicts.get(this.pos(v)).get(posM).booleanValue() || (!leftToRight || r >= posM) && (leftToRight || r <= posM)) continue;
                        align.put(m, v);
                        root.put(v, root.get(m));
                        align.put(v, root.get(v));
                        r = posM;
                    }
                }
                k = leftToRight ? k + 1 : k - 1;
            }
            i = downward ? i + 1 : i - 1;
        }
    }

    private void computeBlockWidths(HashMap<Node, Node> root, HashMap<Node, Float> blockWidth) {
        for (Node v : this.graph.getNodes()) {
            Node r = root.get(v);
            blockWidth.put(r, Float.valueOf(Math.max(blockWidth.get(r).floatValue(), (float)v.getWidth())));
        }
    }

    private void horizontalCompactation(HashMap<Node, Node> align, HashMap<Node, Node> root, HashMap<Node, Node> sink, HashMap<Node, Float> shift, HashMap<Node, Float> blockWidth, HashMap<Node, Float> x, boolean leftToRight, boolean downward) {
        int i;
        Node v;
        int i2;
        int n = i2 = downward ? 0 : this.layers.size() - 1;
        while (downward && i2 <= this.layers.size() - 1 || !downward && i2 >= 0) {
            int j;
            List<Node> currentLevel = this.layers.get(i2);
            int n2 = j = leftToRight ? 0 : currentLevel.size() - 1;
            while (leftToRight && j <= currentLevel.size() - 1 || !leftToRight && j >= 0) {
                v = currentLevel.get(j);
                if (root.get(v).equals(v)) {
                    this.placeBlock(v, sink, shift, x, align, blockWidth, root, leftToRight);
                }
                j = leftToRight ? j + 1 : j - 1;
            }
            i2 = downward ? i2 + 1 : i2 - 1;
        }
        float d = 0.0f;
        int n3 = i = downward ? 0 : this.layers.size() - 1;
        while (downward && i <= this.layers.size() - 1 || !downward && i >= 0) {
            List<Node> currentLevel = this.layers.get(i);
            v = currentLevel.get(leftToRight ? 0 : currentLevel.size() - 1);
            if (v.equals(sink.get(root.get(v)))) {
                Float oldShift = shift.get(v);
                if (oldShift.floatValue() < Float.MAX_VALUE) {
                    shift.put(v, Float.valueOf(oldShift.floatValue() + d));
                    d += oldShift.floatValue();
                } else {
                    shift.put(v, Float.valueOf(0.0f));
                }
            }
            i = downward ? i + 1 : i - 1;
        }
        for (Node v2 : this.graph.getNodes()) {
            x.put(v2, x.get(root.get(v2)));
            Float shiftVal = shift.get(sink.get(root.get(v2)));
            if (!(shiftVal.floatValue() < Float.MAX_VALUE)) continue;
            x.put(v2, Float.valueOf(x.get(v2).floatValue() + shiftVal.floatValue()));
        }
    }

    private void placeBlock(Node v, HashMap<Node, Node> sink, HashMap<Node, Float> shift, HashMap<Node, Float> x, HashMap<Node, Node> align, HashMap<Node, Float> blockWidth, HashMap<Node, Node> root, boolean leftToRight) {
        if (x.get(v).equals(Float.valueOf(Float.MIN_VALUE))) {
            x.put(v, Float.valueOf(0.0f));
            Node w = v;
            do {
                if ((!leftToRight || this.pos(w) <= 0) && (leftToRight || this.pos(w) >= this.layers.get(this.getLayerIndex(w)).size() - 1)) continue;
                Node pred = this.pred(w, leftToRight);
                Node u = root.get(pred);
                this.placeBlock(u, sink, shift, x, align, blockWidth, root, leftToRight);
                if (sink.get(v).equals(v)) {
                    sink.put(v, sink.get(u));
                }
                if (!sink.get(v).equals(sink.get(u))) {
                    if (leftToRight) {
                        shift.put(sink.get(u), Float.valueOf(Math.min(shift.get(sink.get(u)).floatValue(), x.get(v).floatValue() - x.get(u).floatValue() - (float)this.configuration.getNodeSeparation() - 0.5f * (blockWidth.get(u).floatValue() + blockWidth.get(v).floatValue()))));
                        continue;
                    }
                    shift.put(sink.get(u), Float.valueOf(Math.max(shift.get(sink.get(u)).floatValue(), x.get(v).floatValue() - x.get(u).floatValue() + (float)this.configuration.getNodeSeparation() + 0.5f * (blockWidth.get(u).floatValue() + blockWidth.get(v).floatValue()))));
                    continue;
                }
                if (leftToRight) {
                    x.put(v, Float.valueOf(Math.max(x.get(v).floatValue(), x.get(u).floatValue() + (float)this.configuration.getNodeSeparation() + 0.5f * (blockWidth.get(u).floatValue() + blockWidth.get(v).floatValue()))));
                    continue;
                }
                x.put(v, Float.valueOf(Math.min(x.get(v).floatValue(), x.get(u).floatValue() - (float)this.configuration.getNodeSeparation() - 0.5f * (blockWidth.get(u).floatValue() + blockWidth.get(v).floatValue()))));
            } while (!(w = align.get(w)).equals(v));
        }
    }

    private Node pred(Node v, boolean leftToRight) {
        int pos = this.pos(v);
        int rank = this.getLayerIndex(v);
        List<Node> level = this.layers.get(rank);
        if (leftToRight && pos != 0 || !leftToRight && pos != level.size() - 1) {
            return level.get(leftToRight ? pos - 1 : pos + 1);
        }
        return null;
    }

    private Node virtualTwinNode(Node node, boolean downward) {
        if (!this.isLongEdgeDummy(node)) {
            return null;
        }
        List<Node> adjNodes = this.getAdjNodes(node, downward);
        if (adjNodes.size() == 0) {
            return null;
        }
        return adjNodes.get(0);
    }

    private List<Node> getAdjNodes(Node node, boolean downward) {
        return downward ? this.graph.predecessorsOf(node) : this.graph.successorsOf(node);
    }

    private int pos(Node node) {
        for (List<Node> l : this.layers) {
            for (Node n : l) {
                if (!node.equals(n)) continue;
                return l.indexOf(node);
            }
        }
        return -1;
    }

    private int getLayerIndex(Node node) {
        for (int l = 0; l < this.layers.size(); ++l) {
            for (Node n : this.layers.get(l)) {
                if (!node.equals(n)) continue;
                return l;
            }
        }
        return -1;
    }

    private boolean isLongEdgeDummy(Node v) {
        List<Node> successors = this.graph.successorsOf(v);
        return this.nodeData.get(v).isDummy() && successors.size() == 1 && this.nodeData.get(successors.get(0)).isDummy();
    }

    private void assignY() {
        int k = this.layers.size();
        Object[] data = new Float[this.graph.getNodes().size()];
        Arrays.fill(data, Float.valueOf(0.0f));
        ArrayList<Object> height = new ArrayList<Object>(Arrays.asList(data));
        for (int i = 0; i < k; ++i) {
            List<Node> level = this.layers.get(i);
            for (int j = 0; j < level.size(); ++j) {
                float h;
                Node node = level.get(j);
                float f = h = this.nodeData.get(node).isDummy() ? 0.0f : (float)node.getHeight();
                if (!(h > ((Float)height.get(i)).floatValue())) continue;
                height.set(i, Float.valueOf(h));
            }
        }
        float yPos = 0.0f;
        int i = 0;
        while (true) {
            List<Node> level = this.layers.get(i);
            for (int j = 0; j < level.size(); ++j) {
                level.get(j).setY(yPos);
            }
            if (i == k - 1) break;
            yPos = (float)((double)yPos + ((double)this.configuration.getLevelSeparation() + 0.5 * (double)(((Float)height.get(i)).floatValue() + ((Float)height.get(i + 1)).floatValue())));
            ++i;
        }
    }

    private void denormalize() {
        for (int i = 1; i < this.layers.size() - 1; ++i) {
            Iterator<Node> iterator = this.layers.get(i).iterator();
            while (iterator.hasNext()) {
                Node current = iterator.next();
                if (!this.nodeData.get(current).isDummy()) continue;
                Node predecessor = this.graph.predecessorsOf(current).get(0);
                Node successor = this.graph.successorsOf(current).get(0);
                List<Float> bendPoints = this.edgeData.get((Object)this.graph.getEdge((Node)predecessor, (Node)current)).bendPoints;
                if (bendPoints.isEmpty() || !bendPoints.contains(Float.valueOf(current.getX() + (float)predecessor.getWidth() / 2.0f))) {
                    bendPoints.add(Float.valueOf(predecessor.getX() + (float)predecessor.getWidth() / 2.0f));
                    bendPoints.add(Float.valueOf(predecessor.getY() + (float)predecessor.getHeight() / 2.0f));
                    bendPoints.add(Float.valueOf(current.getX() + (float)predecessor.getWidth() / 2.0f));
                    bendPoints.add(Float.valueOf(current.getY()));
                }
                if (!this.nodeData.get(predecessor).isDummy()) {
                    bendPoints.add(Float.valueOf(current.getX() + (float)predecessor.getWidth() / 2.0f));
                } else {
                    bendPoints.add(Float.valueOf(current.getX()));
                }
                bendPoints.add(Float.valueOf(current.getY()));
                if (this.nodeData.get(successor).isDummy()) {
                    bendPoints.add(Float.valueOf(successor.getX() + (float)predecessor.getWidth() / 2.0f));
                } else {
                    bendPoints.add(Float.valueOf(successor.getX() + (float)successor.getWidth() / 2.0f));
                }
                bendPoints.add(Float.valueOf(successor.getY() + (float)successor.getHeight() / 2.0f));
                this.graph.removeEdge(predecessor, current);
                this.graph.removeEdge(current, successor);
                Edge edge = this.graph.addEdge(predecessor, successor);
                SugiyamaEdgeData sugiyamaEdgeData = new SugiyamaEdgeData();
                sugiyamaEdgeData.bendPoints = bendPoints;
                this.edgeData.put(edge, sugiyamaEdgeData);
                iterator.remove();
                this.graph.removeNode(current);
            }
        }
    }

    private void restoreCycle() {
        for (Node n : this.graph.getNodes()) {
            if (!this.nodeData.get(n).isReversed()) continue;
            Iterator<Edge> iterator = this.graph.getEdges().iterator();
            while (iterator.hasNext()) {
                Edge edge = iterator.next();
                if (edge.getDestination().equals(n) || edge.getSource().equals(n)) {
                    this.graph.addEdge(edge.getDestination(), edge.getSource());
                }
                iterator.remove();
            }
        }
    }

    @Override
    public void drawEdges(Canvas canvas, Graph graph, Paint mLinePaint) {
        this.edgeRenderer.render(canvas, this.graph, mLinePaint);
    }

    @Override
    public void setEdgeRenderer(EdgeRenderer renderer) {
        throw new UnsupportedOperationException("SugiyamaAlgorithm currently not support custom edge renderer!");
    }

    @Override
    public Size getGraphSize() {
        return this.size;
    }

    private String getDummyText() {
        return "Dummy " + this.nodeCount++;
    }
}

