/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.support.annotation.Px;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import de.blox.graphview.GraphAdapter;
import de.blox.graphview.Node;
import de.blox.graphview.R;
import de.blox.graphview.Size;
import de.blox.graphview.Vector;

class GraphNodeContainerView
extends AdapterView<GraphAdapter> {
    public static final boolean DEFAULT_USE_MAX_SIZE = false;
    private static final int DEFAULT_LINE_THICKNESS = 5;
    private static final int DEFAULT_LINE_COLOR = -16777216;
    private static final int INVALID_INDEX = -1;
    private Paint linePaint = new Paint();
    private int lineThickness;
    private int lineColor;
    private boolean useMaxSize;
    private GraphAdapter adapter;
    private int maxChildWidth;
    private int maxChildHeight;
    private Rect rect = new Rect();
    private DataSetObserver dataSetObserver;
    private GestureDetector gestureDetector;

    public GraphNodeContainerView(Context context) {
        this(context, null);
    }

    public GraphNodeContainerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GraphNodeContainerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private static int makeMeasureSpec(int dimension) {
        int spec = dimension > 0 ? View.MeasureSpec.makeMeasureSpec((int)dimension, (int)0x40000000) : 0;
        return spec;
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            this.initAttrs(context, attrs);
        }
        this.initPaint();
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureListener());
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.GraphView, 0, 0);
        this.lineThickness = a.getDimensionPixelSize(R.styleable.GraphView_lineThickness, 5);
        this.lineColor = a.getColor(R.styleable.GraphView_lineColor, -16777216);
        this.useMaxSize = a.getBoolean(R.styleable.GraphView_useMaxSize, false);
        a.recycle();
    }

    private void initPaint() {
        this.linePaint = new Paint(1);
        this.linePaint.setStrokeWidth((float)this.lineThickness);
        this.linePaint.setColor(this.lineColor);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setStrokeJoin(Paint.Join.ROUND);
        this.linePaint.setPathEffect((PathEffect)new CornerPathEffect(10.0f));
    }

    private void positionItems() {
        int maxLeft = Integer.MAX_VALUE;
        int maxRight = Integer.MIN_VALUE;
        int maxTop = Integer.MAX_VALUE;
        int maxBottom = Integer.MIN_VALUE;
        for (int index = 0; index < this.adapter.getCount(); ++index) {
            View child = this.adapter.getView(index, null, (ViewGroup)this);
            this.addAndMeasureChild(child);
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            Vector screenPosition = this.adapter.getScreenPosition(index);
            int left = (int)screenPosition.getX();
            int top = (int)screenPosition.getY();
            int right = left + width;
            int bottom = top + height;
            child.layout(left, top, right, bottom);
            maxRight = Math.max(maxRight, right);
            maxLeft = Math.min(maxLeft, left);
            maxBottom = Math.max(maxBottom, bottom);
            maxTop = Math.min(maxTop, top);
        }
    }

    private void addAndMeasureChild(View child) {
        ViewGroup.LayoutParams params = child.getLayoutParams();
        if (params == null) {
            params = new ViewGroup.LayoutParams(-2, -2);
        }
        this.addViewInLayout(child, -1, params, false);
        int widthSpec = GraphNodeContainerView.makeMeasureSpec(params.width);
        int heightSpec = GraphNodeContainerView.makeMeasureSpec(params.height);
        if (this.useMaxSize) {
            widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxChildWidth, (int)0x40000000);
            heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxChildHeight, (int)0x40000000);
        }
        child.measure(widthSpec, heightSpec);
    }

    private int getContainingChildIndex(int x, int y) {
        if (this.rect == null) {
            this.rect = new Rect();
        }
        for (int index = 0; index < this.getChildCount(); ++index) {
            this.getChildAt(index).getHitRect(this.rect);
            if (!this.rect.contains(x, y)) continue;
            return index;
        }
        return -1;
    }

    private void clickChildAt(int x, int y) {
        int index = this.getContainingChildIndex(x, y);
        if (index == -1) {
            return;
        }
        View itemView = this.getChildAt(index);
        long id = this.adapter.getItemId(index);
        this.performItemClick(itemView, index, id);
    }

    private void longClickChildAt(int x, int y) {
        int index = this.getContainingChildIndex(x, y);
        if (index == -1) {
            return;
        }
        View itemView = this.getChildAt(index);
        long id = this.adapter.getItemId(index);
        AdapterView.OnItemLongClickListener listener = this.getOnItemLongClickListener();
        if (listener != null) {
            listener.onItemLongClick((AdapterView)this, itemView, index, id);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.gestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(@Px int lineThickness) {
        this.lineThickness = lineThickness;
        this.initPaint();
        this.invalidate();
    }

    @ColorInt
    public int getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(@ColorInt int lineColor) {
        this.lineColor = lineColor;
        this.initPaint();
        this.invalidate();
    }

    public boolean isUsingMaxSize() {
        return this.useMaxSize;
    }

    public void setUseMaxSize(boolean useMaxSize) {
        this.useMaxSize = useMaxSize;
        this.invalidate();
        this.requestLayout();
    }

    public GraphAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(GraphAdapter adapter) {
        if (this.adapter != null && this.dataSetObserver != null) {
            this.adapter.unregisterDataSetObserver(this.dataSetObserver);
        }
        this.adapter = adapter;
        this.dataSetObserver = new GraphDataSetObserver();
        this.adapter.registerDataSetObserver(this.dataSetObserver);
        this.requestLayout();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.adapter == null) {
            return;
        }
        this.removeAllViewsInLayout();
        this.positionItems();
        this.invalidate();
    }

    public View getSelectedView() {
        return null;
    }

    public void setSelection(int position) {
    }

    protected void dispatchDraw(Canvas canvas) {
        GraphAdapter adapter = this.getAdapter();
        if (adapter != null && adapter.getGraph() != null) {
            adapter.getAlgorithm().drawEdges(canvas, adapter.getGraph(), this.linePaint);
        }
        super.dispatchDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Node node;
        ViewGroup.LayoutParams params;
        View child;
        int i;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.adapter == null) {
            return;
        }
        int maxWidth = 0;
        int maxHeight = 0;
        int minHeight = Integer.MAX_VALUE;
        for (i = 0; i < this.adapter.getCount(); ++i) {
            child = this.adapter.getView(i, null, (ViewGroup)this);
            params = child.getLayoutParams();
            if (params == null) {
                params = new ViewGroup.LayoutParams(-2, -2);
            }
            this.addViewInLayout(child, -1, params, true);
            int childWidthSpec = GraphNodeContainerView.makeMeasureSpec(params.width);
            int childHeightSpec = GraphNodeContainerView.makeMeasureSpec(params.height);
            child.measure(childWidthSpec, childHeightSpec);
            node = this.adapter.getNode(i);
            int measuredWidth = child.getMeasuredWidth();
            int measuredHeight = child.getMeasuredHeight();
            node.setSize(measuredWidth, measuredHeight);
            maxWidth = Math.max(maxWidth, measuredWidth);
            maxHeight = Math.max(maxHeight, measuredHeight);
            minHeight = Math.min(minHeight, measuredHeight);
        }
        this.maxChildWidth = maxWidth;
        this.maxChildHeight = maxHeight;
        if (this.useMaxSize) {
            this.removeAllViewsInLayout();
            for (i = 0; i < this.adapter.getCount(); ++i) {
                child = this.adapter.getView(i, null, (ViewGroup)this);
                params = child.getLayoutParams();
                if (params == null) {
                    params = new ViewGroup.LayoutParams(-2, -2);
                }
                this.addViewInLayout(child, -1, params, true);
                int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxChildWidth, (int)0x40000000);
                int heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxChildHeight, (int)0x40000000);
                child.measure(widthSpec, heightSpec);
                node = this.adapter.getNode(i);
                node.setSize(child.getMeasuredWidth(), child.getMeasuredHeight());
            }
        }
        this.adapter.notifySizeChanged();
        Size size = this.adapter.getAlgorithm().getGraphSize();
        this.setMeasuredDimension(size.getWidth(), size.getHeight());
    }

    private class GraphDataSetObserver
    extends DataSetObserver {
        private GraphDataSetObserver() {
        }

        public void onChanged() {
            super.onChanged();
            this.refresh();
        }

        public void onInvalidated() {
            super.onInvalidated();
            this.refresh();
        }

        private void refresh() {
            GraphNodeContainerView.this.requestLayout();
            GraphNodeContainerView.this.invalidate();
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            GraphNodeContainerView.this.clickChildAt((int)e.getX(), (int)e.getY());
            return true;
        }

        public void onLongPress(MotionEvent e) {
            GraphNodeContainerView.this.longClickChildAt((int)e.getX(), (int)e.getY());
        }
    }
}

