/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview;

import android.support.annotation.NonNull;
import de.blox.graphview.Edge;
import de.blox.graphview.Node;
import de.blox.graphview.NodeObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Graph {
    private List<Node> nodes = new ArrayList<Node>();
    private List<Edge> edges = new ArrayList<Edge>();
    private List<NodeObserver> observers = new ArrayList<NodeObserver>();
    private boolean isTree = false;

    public void addNode(@NonNull Node node) {
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
        }
    }

    public void addNodes(Node ... nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.addNode(nodes[i]);
        }
    }

    public void removeNode(@NonNull Node node) {
        this.removeNodeInternal(node);
        for (NodeObserver observer : this.observers) {
            observer.notifyNodeRemoved(node);
        }
    }

    private void removeNodeInternal(Node node) {
        if (!this.nodes.contains(node)) {
            throw new IllegalArgumentException("Unable to find node in graph.");
        }
        if (this.isTree) {
            for (Node n : this.successorsOf(node)) {
                this.removeNodeInternal(n);
            }
        }
        this.nodes.remove(node);
        Iterator<Edge> iterator = this.edges.iterator();
        while (iterator.hasNext()) {
            Edge edge = iterator.next();
            if (!edge.getSource().equals(node) && !edge.getDestination().equals(node)) continue;
            iterator.remove();
        }
    }

    public void removeNodes(Node ... nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.removeNode(nodes[i]);
        }
    }

    public Edge addEdge(@NonNull Node source, @NonNull Node destination) {
        this.addNode(source);
        this.addNode(destination);
        Edge edge = new Edge(source, destination);
        this.edges.add(edge);
        for (NodeObserver observer : this.observers) {
            observer.notifyInvalidated();
        }
        return edge;
    }

    public void addEdge(@NonNull Edge edge) {
        if (!this.edges.contains(edge)) {
            this.edges.add(edge);
        }
    }

    public void addEdges(Edge ... edges) {
        for (int i = 0; i < edges.length; ++i) {
            this.addEdge(edges[i]);
        }
    }

    public void removeEdge(Edge edge) {
        this.edges.remove(edge);
    }

    public void removeEdges(Edge ... edges) {
        for (int i = 0; i < edges.length; ++i) {
            this.removeEdge(edges[i]);
        }
    }

    public void removeEdge(Node predecessor, Node current) {
        Iterator<Edge> iterator = this.getEdges().iterator();
        while (iterator.hasNext()) {
            Edge edge = iterator.next();
            if (!edge.getSource().equals(predecessor) || !edge.getDestination().equals(current)) continue;
            iterator.remove();
        }
    }

    public void addNodeObserver(NodeObserver nodeObserver) {
        this.observers.add(nodeObserver);
    }

    public void removeNodeObserver(NodeObserver nodeObserver) {
        this.observers.remove(nodeObserver);
    }

    public boolean hasNodes() {
        return !this.nodes.isEmpty();
    }

    public Node getNode(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position can't be negative");
        }
        int size = this.nodes.size();
        if (position >= size) {
            throw new IndexOutOfBoundsException("Position: " + position + ", Size: " + size);
        }
        return this.nodes.get(position);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public Edge getEdge(Node source, Node destination) {
        for (Edge edge : this.getEdges()) {
            if (!edge.getSource().equals(source) || !edge.getDestination().equals(destination)) continue;
            return edge;
        }
        return null;
    }

    public boolean hasSuccessor(Node node) {
        for (Edge edge : this.edges) {
            if (!edge.getSource().equals(node)) continue;
            return true;
        }
        return false;
    }

    public List<Node> successorsOf(Node node) {
        ArrayList<Node> successors = new ArrayList<Node>();
        for (Edge edge : this.edges) {
            if (!edge.getSource().equals(node)) continue;
            successors.add(edge.getDestination());
        }
        return successors;
    }

    public boolean hasPredecessor(Node node) {
        for (Edge edge : this.edges) {
            if (!edge.getDestination().equals(node)) continue;
            return true;
        }
        return false;
    }

    public List<Node> predecessorsOf(Node node) {
        ArrayList<Node> predecessors = new ArrayList<Node>();
        for (Edge edge : this.edges) {
            if (!edge.getDestination().equals(node)) continue;
            predecessors.add(edge.getSource());
        }
        return predecessors;
    }

    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    public boolean containsData(Object data) {
        for (Node node : this.nodes) {
            if (!node.getData().equals(data)) continue;
            return true;
        }
        return false;
    }

    public Node getNode(Object data) {
        for (Node node : this.nodes) {
            if (!node.getData().equals(data)) continue;
            return node;
        }
        return null;
    }

    public List<Edge> getOutEdges(Node node) {
        ArrayList<Edge> outEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getSource().equals(node)) continue;
            outEdges.add(edge);
        }
        return outEdges;
    }

    private List<Edge> getInEdges(Node node) {
        ArrayList<Edge> inEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getDestination().equals(node)) continue;
            inEdges.add(edge);
        }
        return inEdges;
    }

    public void setAsTree(boolean isTree) {
        this.isTree = isTree;
    }
}

