/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview;

import android.content.Context;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import de.blox.graphview.Algorithm;
import de.blox.graphview.Conditions;
import de.blox.graphview.Graph;
import de.blox.graphview.GraphAdapter;
import de.blox.graphview.Node;
import de.blox.graphview.Vector;
import de.blox.graphview.tree.BuchheimWalkerAlgorithm;

public abstract class BaseGraphAdapter<VH>
implements GraphAdapter<VH> {
    private final int mLayoutRes;
    private Graph graph;
    private Algorithm mAlgorithm;
    private LayoutInflater mLayoutInflater;
    private DataSetObservable mDataSetObservable = new DataSetObservable();

    public BaseGraphAdapter(@NonNull Context context, @LayoutRes int layoutRes) {
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mLayoutRes = layoutRes;
    }

    public BaseGraphAdapter(@NonNull Context context, @LayoutRes int layoutRes, @NonNull Graph graph) {
        this(context, layoutRes);
        this.setGraph(graph);
    }

    @Override
    public void notifySizeChanged() {
        if (this.graph != null && this.graph.getNodeCount() > 0) {
            this.getAlgorithm().run(this.graph);
        }
    }

    @Override
    public Algorithm getAlgorithm() {
        if (this.mAlgorithm == null) {
            this.mAlgorithm = new BuchheimWalkerAlgorithm();
        }
        return this.mAlgorithm;
    }

    @Override
    public void setAlgorithm(@NonNull Algorithm algorithm) {
        Conditions.isNonNull(algorithm, "algorithm can't be null");
        this.mAlgorithm = algorithm;
        this.graph.setAsTree(this.getAlgorithm() instanceof BuchheimWalkerAlgorithm);
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(@NonNull Graph graph) {
        Conditions.isNonNull(graph, "graph can't be null");
        if (this.graph != null) {
            this.graph.removeNodeObserver(this);
        }
        this.graph = graph;
        this.graph.addNodeObserver(this);
        this.mDataSetObservable.notifyChanged();
        graph.setAsTree(this.getAlgorithm() instanceof BuchheimWalkerAlgorithm);
    }

    @Override
    public Node getNode(int position) {
        return this.graph != null ? this.graph.getNode(position) : null;
    }

    @Override
    public Vector getScreenPosition(int position) {
        return this.getNode(position).getPosition();
    }

    public int getCount() {
        return this.graph != null ? this.graph.getNodeCount() : 0;
    }

    @Override
    public void notifyDataChanged(Node node) {
        this.mDataSetObservable.notifyChanged();
    }

    @Override
    public void notifyNodeAdded(Node node) {
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public void notifyNodeRemoved(Node node) {
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public void notifyInvalidated() {
        this.mDataSetObservable.notifyInvalidated();
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }

    public Object getItem(int position) {
        return this.getNode(position).getData();
    }

    public long getItemId(int position) {
        return 0L;
    }

    public boolean hasStableIds() {
        return false;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Object viewHolder;
        View view;
        if (convertView == null) {
            view = this.mLayoutInflater.inflate(this.mLayoutRes, parent, false);
            viewHolder = this.onCreateViewHolder(view);
            view.setTag(viewHolder);
        } else {
            view = convertView;
            viewHolder = view.getTag();
        }
        Node node = this.getNode(position);
        this.onBindViewHolder(viewHolder, node.getData(), position);
        return view;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 0;
    }

    public boolean isEmpty() {
        return false;
    }
}

