/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.energy;

import android.graphics.Canvas;
import android.graphics.Paint;
import de.blox.graphview.Algorithm;
import de.blox.graphview.Edge;
import de.blox.graphview.EdgeRenderer;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.Vector;
import de.blox.graphview.energy.EnergyEdgeRenderer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class FruchtermanReingoldAlgorithm
implements Algorithm {
    public static final int DEFAULT_ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-4;
    private static final long SEED = 401678L;
    private final EdgeRenderer edgeRenderer = new EnergyEdgeRenderer();
    private final int iterations;
    private Map<Node, Vector> disps = new HashMap<Node, Vector>();
    private Random rand = new Random(401678L);
    private int width;
    private int height;
    private float k;
    private float t;
    private float attraction_k;
    private float repulsion_k;

    public FruchtermanReingoldAlgorithm() {
        this(1000);
    }

    public FruchtermanReingoldAlgorithm(int iterations) {
        this.iterations = iterations;
    }

    private static int randInt(Random rand, int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    private void randomize(List<Node> nodes) {
        for (Node node : nodes) {
            this.disps.put(node, new Vector());
            if (node.getPosition() != null) continue;
            node.setPos(new Vector(FruchtermanReingoldAlgorithm.randInt(this.rand, 0, this.width), FruchtermanReingoldAlgorithm.randInt(this.rand, 0, this.height)));
        }
    }

    private void cool(int currentIteration) {
        this.t = (float)((double)this.t * (1.0 - (double)currentIteration / (double)this.iterations));
    }

    private void limitMaximumDisplacement(List<Node> nodes) {
        for (Node v : nodes) {
            float dispLength = (float)Math.max(1.0E-4, (double)this.getDisp(v).length());
            v.setPos(v.getPosition().add(this.getDisp(v).divide(dispLength).multiply(Math.min(dispLength, this.t))));
        }
    }

    private void calculateAttraction(List<Edge> edges) {
        for (Edge e : edges) {
            Node v = e.getSource();
            Node u = e.getDestination();
            Vector delta = v.getPosition().subtract(u.getPosition());
            float deltaLength = (float)Math.max(1.0E-4, (double)delta.length());
            this.setDisp(v, this.getDisp(v).subtract(delta.divide(deltaLength).multiply(this.forceAttraction(deltaLength))));
            this.setDisp(u, this.getDisp(u).add(delta.divide(deltaLength).multiply(this.forceAttraction(deltaLength))));
        }
    }

    private void calculateRepulsion(List<Node> nodes) {
        for (Node v : nodes) {
            for (Node u : nodes) {
                if (u.equals(v)) continue;
                Vector delta = v.getPosition().subtract(u.getPosition());
                float deltaLength = (float)Math.max(1.0E-4, (double)delta.length());
                this.setDisp(v, this.getDisp(v).add(delta.divide(deltaLength).multiply(this.forceRepulsion(deltaLength))));
            }
        }
    }

    private float forceAttraction(float x) {
        return x * x / this.attraction_k;
    }

    private float forceRepulsion(float x) {
        return this.repulsion_k * this.repulsion_k / x;
    }

    private Vector getDisp(Node node) {
        return this.disps.get(node);
    }

    private void setDisp(Node node, Vector disp) {
        this.disps.put(node, disp);
    }

    @Override
    public void run(Graph graph) {
        int size;
        this.width = size = this.findBiggestSize(graph) * graph.getNodeCount();
        this.height = size;
        List<Node> nodes = graph.getNodes();
        List<Edge> edges = graph.getEdges();
        this.t = (float)(0.1 * Math.sqrt(this.width / 2 * this.height / 2));
        this.k = (float)(0.75 * Math.sqrt(this.width * this.height / nodes.size()));
        this.attraction_k = 0.75f * this.k;
        this.repulsion_k = 0.75f * this.k;
        this.randomize(nodes);
        for (int i = 0; i < this.iterations; ++i) {
            this.calculateRepulsion(nodes);
            this.calculateAttraction(edges);
            this.limitMaximumDisplacement(nodes);
            this.cool(i);
            if (this.done()) break;
        }
        this.positionNodes(graph);
    }

    private void positionNodes(Graph graph) {
        Vector offset = this.getOffset(graph);
        for (Node node : graph.getNodes()) {
            node.setPos(new Vector(node.getX() - offset.getX(), node.getY() - offset.getY()));
        }
    }

    private int findBiggestSize(Graph graph) {
        int size = 0;
        for (Node node : graph.getNodes()) {
            size = Math.max(size, Math.max(node.getHeight(), node.getWidth()));
        }
        return size;
    }

    private Vector getOffset(Graph graph) {
        float offsetX = Float.MAX_VALUE;
        float offsetY = Float.MAX_VALUE;
        for (Node node : graph.getNodes()) {
            offsetX = Math.min(offsetX, node.getX());
            offsetY = Math.min(offsetY, node.getY());
        }
        return new Vector(offsetX, offsetY);
    }

    private boolean done() {
        return (double)this.t < 1.0 / (double)Math.max(this.height, this.width);
    }

    @Override
    public void drawEdges(Canvas canvas, Graph graph, Paint linePaint) {
        this.edgeRenderer.render(canvas, graph, linePaint);
    }
}

