/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import de.blox.graphview.GraphAdapter;
import de.blox.graphview.Node;
import de.blox.graphview.R;
import de.blox.graphview.Vector;

public class GraphView
extends AdapterView<GraphAdapter>
implements GestureDetector.OnGestureListener {
    public static final boolean DEFAULT_USE_MAX_SIZE = false;
    private static final int DEFAULT_LINE_THICKNESS = 5;
    private static final int DEFAULT_LINE_COLOR = -16777216;
    private static final int INVALID_INDEX = -1;
    private Paint mLinePaint = new Paint();
    private int mLineThickness;
    private int mLineColor;
    private boolean mUseMaxSize;
    private GraphAdapter mAdapter;
    private int mMaxChildWidth;
    private int mMaxChildHeight;
    private Rect mRect;
    private Rect mBoundaries = new Rect();
    private DataSetObserver mDataSetObserver;
    private GestureDetector mGestureDetector;

    public GraphView(Context context) {
        this(context, null);
    }

    public GraphView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GraphView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @RequiresApi(api=21)
    public GraphView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private static int makeMeasureSpec(int dimension) {
        int spec = dimension > 0 ? View.MeasureSpec.makeMeasureSpec((int)dimension, (int)0x40000000) : 0;
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.GraphView, 0, 0);
        try {
            this.mLineThickness = a.getDimensionPixelSize(R.styleable.GraphView_lineThickness, 5);
            this.mLineColor = a.getColor(R.styleable.GraphView_lineColor, -16777216);
            this.mUseMaxSize = a.getBoolean(R.styleable.GraphView_useMaxSize, false);
        }
        finally {
            a.recycle();
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        if (attrs != null) {
            this.initAttrs(context, attrs);
        }
        this.initPaint();
    }

    private void initPaint() {
        this.mLinePaint = new Paint(1);
        this.mLinePaint.setStrokeWidth((float)this.mLineThickness);
        this.mLinePaint.setColor(this.mLineColor);
        this.mLinePaint.setStyle(Paint.Style.STROKE);
        this.mLinePaint.setStrokeJoin(Paint.Join.ROUND);
        this.mLinePaint.setPathEffect((PathEffect)new CornerPathEffect(10.0f));
    }

    private void positionItems() {
        int maxLeft = Integer.MAX_VALUE;
        int maxRight = Integer.MIN_VALUE;
        int maxTop = Integer.MAX_VALUE;
        int maxBottom = Integer.MIN_VALUE;
        for (int index = 0; index < this.mAdapter.getCount(); ++index) {
            View child = this.mAdapter.getView(index, null, (ViewGroup)this);
            this.addAndMeasureChild(child);
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            Vector screenPosition = this.mAdapter.getScreenPosition(index);
            int left = (int)screenPosition.getX();
            int top = (int)screenPosition.getY();
            int right = left + width;
            int bottom = top + height;
            child.layout(left, top, right, bottom);
            maxRight = Math.max(maxRight, right);
            maxLeft = Math.min(maxLeft, left);
            maxBottom = Math.max(maxBottom, bottom);
            maxTop = Math.min(maxTop, top);
        }
        this.mBoundaries.set(maxLeft - (this.getWidth() - Math.abs(maxLeft)) - Math.abs(maxLeft), -this.getHeight(), maxRight, maxBottom);
    }

    private void addAndMeasureChild(View child) {
        ViewGroup.LayoutParams params = child.getLayoutParams();
        if (params == null) {
            params = new ViewGroup.LayoutParams(-2, -2);
        }
        this.addViewInLayout(child, -1, params, false);
        int widthSpec = GraphView.makeMeasureSpec(params.width);
        int heightSpec = GraphView.makeMeasureSpec(params.height);
        if (this.mUseMaxSize) {
            widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxChildWidth, (int)0x40000000);
            heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxChildHeight, (int)0x40000000);
        }
        child.measure(widthSpec, heightSpec);
    }

    private int getContainingChildIndex(int x, int y) {
        if (this.mRect == null) {
            this.mRect = new Rect();
        }
        for (int index = 0; index < this.getChildCount(); ++index) {
            this.getChildAt(index).getHitRect(this.mRect);
            if (!this.mRect.contains(x, y)) continue;
            return index;
        }
        return -1;
    }

    private void clickChildAt(int x, int y) {
        int index = this.getContainingChildIndex(x, y);
        if (index == -1) {
            return;
        }
        View itemView = this.getChildAt(index);
        long id = this.mAdapter.getItemId(index);
        this.performItemClick(itemView, index, id);
    }

    private void longClickChildAt(int x, int y) {
        int index = this.getContainingChildIndex(x, y);
        if (index == -1) {
            return;
        }
        View itemView = this.getChildAt(index);
        long id = this.mAdapter.getItemId(index);
        AdapterView.OnItemLongClickListener listener = this.getOnItemLongClickListener();
        if (listener != null) {
            listener.onItemLongClick((AdapterView)this, itemView, index, id);
        }
    }

    public int getLineThickness() {
        return this.mLineThickness;
    }

    public void setLineThickness(int lineThickness) {
        this.mLineThickness = lineThickness;
        this.initPaint();
        this.invalidate();
    }

    @ColorInt
    public int getLineColor() {
        return this.mLineColor;
    }

    public void setLineColor(@ColorInt int lineColor) {
        this.mLineColor = lineColor;
        this.initPaint();
        this.invalidate();
    }

    public boolean isUsingMaxSize() {
        return this.mUseMaxSize;
    }

    public void setUseMaxSize(boolean useMaxSize) {
        this.mUseMaxSize = useMaxSize;
        this.invalidate();
        this.requestLayout();
    }

    public boolean onDown(MotionEvent event) {
        return true;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        this.clickChildAt((int)e.getX() + this.getScrollX(), (int)e.getY() + this.getScrollY());
        return true;
    }

    public boolean onScroll(MotionEvent downEvent, MotionEvent event, float distanceX, float distanceY) {
        float newScrollY;
        float newScrollX = (float)this.getScrollX() + distanceX;
        if (this.mBoundaries.contains((int)newScrollX, (int)(newScrollY = (float)this.getScrollY() + distanceY))) {
            this.scrollBy((int)distanceX, (int)distanceY);
        }
        return true;
    }

    public void onLongPress(MotionEvent event) {
        this.longClickChildAt((int)event.getX() + this.getScrollX(), (int)event.getY() + this.getScrollY());
    }

    public boolean onFling(MotionEvent event1, MotionEvent event2, float velocityX, float velocityY) {
        return true;
    }

    public GraphAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(GraphAdapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mAdapter = adapter;
        this.mDataSetObserver = new GraphDataSetObserver();
        this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
        this.requestLayout();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mAdapter == null) {
            return;
        }
        this.removeAllViewsInLayout();
        this.positionItems();
        this.invalidate();
    }

    public View getSelectedView() {
        return null;
    }

    public void setSelection(int position) {
    }

    protected void dispatchDraw(Canvas canvas) {
        this.mAdapter.getAlgorithm().drawEdges(canvas, this.mAdapter.getGraph(), this.mLinePaint);
        super.dispatchDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    public boolean performClick() {
        return super.performClick();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Node node;
        ViewGroup.LayoutParams params;
        View child;
        int i;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mAdapter == null) {
            return;
        }
        int maxWidth = 0;
        int maxHeight = 0;
        int minHeight = Integer.MAX_VALUE;
        for (i = 0; i < this.mAdapter.getCount(); ++i) {
            child = this.mAdapter.getView(i, null, (ViewGroup)this);
            params = child.getLayoutParams();
            if (params == null) {
                params = new ViewGroup.LayoutParams(-2, -2);
            }
            this.addViewInLayout(child, -1, params, true);
            int childWidthSpec = GraphView.makeMeasureSpec(params.width);
            int childHeightSpec = GraphView.makeMeasureSpec(params.height);
            child.measure(childWidthSpec, childHeightSpec);
            node = this.mAdapter.getNode(i);
            int measuredWidth = child.getMeasuredWidth();
            int measuredHeight = child.getMeasuredHeight();
            node.setSize(measuredWidth, measuredHeight);
            maxWidth = Math.max(maxWidth, measuredWidth);
            maxHeight = Math.max(maxHeight, measuredHeight);
            minHeight = Math.min(minHeight, measuredHeight);
        }
        this.mMaxChildWidth = maxWidth;
        this.mMaxChildHeight = maxHeight;
        if (this.mUseMaxSize) {
            this.removeAllViewsInLayout();
            for (i = 0; i < this.mAdapter.getCount(); ++i) {
                child = this.mAdapter.getView(i, null, (ViewGroup)this);
                params = child.getLayoutParams();
                if (params == null) {
                    params = new ViewGroup.LayoutParams(-2, -2);
                }
                this.addViewInLayout(child, -1, params, true);
                int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxChildWidth, (int)0x40000000);
                int heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxChildHeight, (int)0x40000000);
                child.measure(widthSpec, heightSpec);
                node = this.mAdapter.getNode(i);
                node.setSize(child.getMeasuredWidth(), child.getMeasuredHeight());
            }
        }
        this.mAdapter.getAlgorithm().setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        this.mAdapter.notifySizeChanged();
    }

    private class GraphDataSetObserver
    extends DataSetObserver {
        private GraphDataSetObserver() {
        }

        public void onChanged() {
            super.onChanged();
            this.refresh();
        }

        public void onInvalidated() {
            super.onInvalidated();
            this.refresh();
        }

        private void refresh() {
            GraphView.this.requestLayout();
            GraphView.this.invalidate();
        }
    }
}

