/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.node.event;

import brainslug.flow.expression.PredicateExpression;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.event.timer.TimerDefinition;
import brainslug.util.Option;
import java.util.concurrent.TimeUnit;

public abstract class AbstractEventDefinition<Self extends AbstractEventDefinition>
extends FlowNodeDefinition<Self> {
    private PredicateExpression continuePredicate;
    private PredicateExpression conditionPredicate;
    private TimerDefinition elapsedTimeDefinition;
    private TimerDefinition conditionPollingTimeDefinition;

    public Self continueIf(PredicateExpression continuePredicate) {
        this.continuePredicate = continuePredicate;
        return (Self)((AbstractEventDefinition)this.self());
    }

    public Self timePassed(long duration, TimeUnit unit) {
        this.elapsedTimeDefinition = new TimerDefinition(duration, unit);
        return (Self)((AbstractEventDefinition)this.self());
    }

    public Self condition(PredicateExpression conditionPredicate) {
        this.conditionPredicate = conditionPredicate;
        return (Self)((AbstractEventDefinition)this.self());
    }

    public Self pollingInterval(long duration, TimeUnit timeUnit) {
        this.conditionPollingTimeDefinition = new TimerDefinition(duration, timeUnit);
        return (Self)((AbstractEventDefinition)this.self());
    }

    public Option<PredicateExpression> getContinuePredicate() {
        return Option.of(this.continuePredicate);
    }

    public Option<TimerDefinition> getElapsedTimeDefinition() {
        return Option.of(this.elapsedTimeDefinition);
    }

    public Option<PredicateExpression> getConditionPredicate() {
        return Option.of(this.conditionPredicate);
    }

    public Option<TimerDefinition> getConditionPollingTimeDefinition() {
        return Option.of(this.conditionPollingTimeDefinition);
    }
}

