/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.node;

import brainslug.flow.definition.EnumIdentifier;
import brainslug.flow.definition.Identifier;
import brainslug.flow.definition.StringIdentifier;
import brainslug.flow.path.FlowEdgeDefinition;
import brainslug.util.MixableBase;
import java.util.ArrayList;
import java.util.List;

public class FlowNodeDefinition<T extends FlowNodeDefinition>
extends MixableBase<FlowNodeDefinition> {
    Identifier id;
    String displayName;
    String documentation;
    List<FlowEdgeDefinition> incoming = new ArrayList<FlowEdgeDefinition>();
    List<FlowEdgeDefinition> outgoing = new ArrayList<FlowEdgeDefinition>();

    public T id(Enum id) {
        this.id = new EnumIdentifier(id);
        return this.self();
    }

    public T id(String id) {
        this.id = new StringIdentifier(id);
        return this.self();
    }

    public T id(Identifier id) {
        this.id = id;
        return this.self();
    }

    public T display(String displayName) {
        this.displayName = displayName;
        return this.self();
    }

    public T documentation(String documentation) {
        this.documentation = documentation;
        return this.self();
    }

    public T self() {
        return (T)this;
    }

    public FlowNodeDefinition<T> addIncoming(FlowNodeDefinition source) {
        this.incoming.add(new FlowEdgeDefinition(source, this));
        return this;
    }

    public FlowNodeDefinition<T> addOutgoing(FlowNodeDefinition target) {
        this.outgoing.add(new FlowEdgeDefinition(this, target));
        return this;
    }

    public List<FlowEdgeDefinition> getIncoming() {
        return this.incoming;
    }

    public List<FlowEdgeDefinition> getOutgoing() {
        return this.outgoing;
    }

    public Identifier getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName == null ? "" : this.displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowNodeDefinition that = (FlowNodeDefinition)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "FlowNodeDefinition{getIdentifier=" + this.id + ", incoming=" + this.incoming + ", outgoing=" + this.outgoing + '}';
    }
}

