/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.definition;

import brainslug.flow.definition.Identifier;
import brainslug.flow.node.FlowNodeDefinition;
import java.util.ArrayList;
import java.util.List;

public class FlowDefinition {
    private Identifier id;
    private String name;
    List<FlowNodeDefinition> startNodes = new ArrayList<FlowNodeDefinition>();
    List<FlowNodeDefinition> nodes = new ArrayList<FlowNodeDefinition>();

    public <T extends FlowNodeDefinition> T addNode(T flowNodeDefinition) {
        this.nodes.add(flowNodeDefinition);
        return flowNodeDefinition;
    }

    public <T extends FlowNodeDefinition> T addStartNode(T flowNodeDefinition) {
        this.startNodes.add(flowNodeDefinition);
        this.nodes.add(flowNodeDefinition);
        return flowNodeDefinition;
    }

    public FlowNodeDefinition<?> getNode(Identifier id) {
        for (FlowNodeDefinition node : this.nodes) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        throw new IllegalArgumentException("Node with id " + id + " does not exist.");
    }

    public <T extends FlowNodeDefinition> List<FlowNodeDefinition<T>> getNodesByType(Class<T> clazz) {
        ArrayList<FlowNodeDefinition<T>> nodesWithType = new ArrayList<FlowNodeDefinition<T>>();
        for (FlowNodeDefinition node : this.nodes) {
            if (!clazz.isAssignableFrom(node.getClass())) continue;
            nodesWithType.add(node);
        }
        return nodesWithType;
    }

    public <T extends FlowNodeDefinition> T getNode(Identifier id, Class<T> clazz) {
        FlowNodeDefinition<?> node = this.getNode(id);
        if (!clazz.isAssignableFrom(node.getClass())) {
            throw new IllegalArgumentException("Requested node should have type " + clazz.getName());
        }
        return (T)node;
    }

    public FlowNodeDefinition<?> requireSingleStartNode() {
        if (this.getStartNodes().size() != 1) {
            throw new IllegalArgumentException("required single start node, but there are " + this.getNodes().size());
        }
        return this.getStartNodes().get(0);
    }

    public List<FlowNodeDefinition> getNodes() {
        return this.nodes;
    }

    public List<FlowNodeDefinition> getStartNodes() {
        return this.startNodes;
    }

    public boolean contains(FlowNodeDefinition<?> flowNodeDefinition) {
        return this.getNodes().contains(flowNodeDefinition);
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public FlowDefinition name(String name) {
        this.name = name;
        return this;
    }

    public FlowDefinition id(Identifier id) {
        this.id = id;
        return this;
    }
}

