/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.builder;

import brainslug.flow.builder.JdkServiceProxyFactory;
import brainslug.flow.builder.ServiceProxyFactory;
import brainslug.flow.expression.Value;
import brainslug.flow.node.task.CallDefinition;
import brainslug.flow.node.task.InvokeDefinition;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Stack;

public class ServiceCallInvocationSupport {
    Stack<ProxyStackEntry> proxyStack = new Stack();

    public Value argument(Value value) {
        this.proxyStack.push(new ParameterEntry<Value>(value));
        return value;
    }

    public CallDefinition createCallDefinitionFromCurrentStack() {
        if (this.proxyStack.empty()) {
            throw new IllegalStateException("no service invocation given. you must define one first...");
        }
        ProxyStackEntry lastInvocation = this.proxyStack.pop();
        if (lastInvocation instanceof ServiceInvocationEntry) {
            this.proxyStack.clear();
            return (ServiceInvocationEntry)lastInvocation;
        }
        throw new IllegalStateException("you must define a valid service invocation.");
    }

    public boolean empty() {
        return this.proxyStack.empty();
    }

    public <T> T createServiceProxy(final Class<T> clazz) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object o, Method method, Object[] arguments) throws Throwable {
                if (method.getDeclaringClass().getName().equals(Object.class.getName())) {
                    return null;
                }
                ServiceInvocationEntry invocation = new ServiceInvocationEntry(clazz);
                invocation.method(method);
                ServiceCallInvocationSupport.this.proxyStack.add(ServiceCallInvocationSupport.this.withArgumentsFromStack(invocation));
                return null;
            }
        };
        return (T)this.createProxyInstance(clazz, handler);
    }

    private ServiceInvocationEntry withArgumentsFromStack(ServiceInvocationEntry invocation) {
        for (int paramIndex = 0; paramIndex < invocation.getMethod().getParameterTypes().length; ++paramIndex) {
            invocation.arg(this.proxyStack.get(paramIndex));
        }
        return invocation;
    }

    protected <T> Object createProxyInstance(Class<T> clazz, InvocationHandler handler) {
        return this.getServiceProxyFactory().createProxyInstance(clazz, handler);
    }

    protected ServiceProxyFactory getServiceProxyFactory() {
        Iterator<ServiceProxyFactory> proxyFactories = ServiceLoader.load(ServiceProxyFactory.class).iterator();
        if (proxyFactories.hasNext()) {
            return proxyFactories.next();
        }
        return new JdkServiceProxyFactory();
    }

    public class ParameterEntry<T>
    implements ProxyStackEntry {
        T value;

        ParameterEntry(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class ServiceInvocationEntry
    extends InvokeDefinition
    implements ProxyStackEntry {
        public ServiceInvocationEntry(Class<?> serviceClass) {
            super(serviceClass);
        }
    }

    public static interface ProxyStackEntry {
    }
}

