/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.builder;

import brainslug.flow.builder.ServiceCallInvocationSupport;
import brainslug.flow.definition.EnumIdentifier;
import brainslug.flow.definition.FlowDefinition;
import brainslug.flow.definition.Identifier;
import brainslug.flow.definition.StringIdentifier;
import brainslug.flow.expression.EqualsExpression;
import brainslug.flow.expression.Expression;
import brainslug.flow.expression.ExpressionBuilder;
import brainslug.flow.expression.Predicate;
import brainslug.flow.expression.PredicateExpression;
import brainslug.flow.expression.Property;
import brainslug.flow.expression.StringExpression;
import brainslug.flow.expression.Value;
import brainslug.flow.node.EventDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.JoinDefinition;
import brainslug.flow.node.MergeDefinition;
import brainslug.flow.node.TaskDefinition;
import brainslug.flow.node.event.AbstractEventDefinition;
import brainslug.flow.node.event.StartEvent;
import brainslug.flow.node.event.timer.StartTimerDefinition;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.node.task.CallDefinition;
import brainslug.flow.node.task.GoalDefinition;
import brainslug.flow.node.task.HandlerCallDefinition;
import brainslug.flow.node.task.InvokeDefinition;
import brainslug.flow.node.task.Task;
import brainslug.flow.path.FlowPathDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class FlowBuilderSupport {
    protected FlowDefinition definition = new FlowDefinition();
    protected ServiceCallInvocationSupport serviceCallInvocation = new ServiceCallInvocationSupport();

    public static Identifier id(Enum id) {
        return new EnumIdentifier(id);
    }

    public static Identifier id(String id) {
        return new StringIdentifier(id);
    }

    public static Identifier id() {
        return new StringIdentifier(FlowBuilderSupport.generateId());
    }

    protected static String generateId() {
        return UUID.randomUUID().toString();
    }

    public StartTimerDefinition every(int interval, TimeUnit intervalUnit) {
        return new StartTimerDefinition(interval, intervalUnit);
    }

    public FlowPathDefinition start(Identifier startId) {
        return this.start(FlowBuilderSupport.event(startId));
    }

    public FlowPathDefinition start(Identifier startId, StartTimerDefinition startTimerDefinition) {
        return this.start(FlowBuilderSupport.event(startId), startTimerDefinition);
    }

    public FlowPathDefinition start(AbstractEventDefinition event) {
        return new FlowPathDefinition(this.definition, this.definition.addStartNode(this.startEvent(event)));
    }

    public FlowPathDefinition start(AbstractEventDefinition event, StartTimerDefinition startTimerDefinition) {
        return this.start(this.timerEvent(event, startTimerDefinition));
    }

    protected AbstractEventDefinition startEvent(AbstractEventDefinition<?> event) {
        if (event.is((Class)StartEvent.class)) {
            return event;
        }
        event.with(new StartEvent());
        return event;
    }

    protected AbstractEventDefinition timerEvent(AbstractEventDefinition event, StartTimerDefinition startTimerDefinition) {
        event.with(new StartEvent().withRecurringTimerDefinition(startTimerDefinition));
        return event;
    }

    public FlowPathDefinition start(AbstractTaskDefinition task) {
        return new FlowPathDefinition(this.definition, this.definition.addStartNode(task));
    }

    public FlowPathDefinition start(Identifier id, AbstractTaskDefinition task, StartTimerDefinition startTimerDefinition) {
        return this.start(FlowBuilderSupport.event(id), startTimerDefinition).execute(task);
    }

    public FlowPathDefinition after(Identifier id) {
        return new FlowPathDefinition(this.definition, this.definition.getNode(id));
    }

    public FlowPathDefinition on(Identifier id) {
        return new FlowPathDefinition(this.definition, this.definition.getNode(id, AbstractEventDefinition.class));
    }

    public FlowPathDefinition merge(Identifier mergeId, Identifier ... ids) {
        MergeDefinition mergeDefinition = (MergeDefinition)new MergeDefinition().id(mergeId);
        this.definition.addNode(mergeDefinition);
        this.connectToNode(mergeDefinition, Arrays.asList(ids));
        return new FlowPathDefinition(this.definition, mergeDefinition);
    }

    public FlowPathDefinition merge(FlowNodeDefinition<?> ... nodeDefinitions) {
        return this.merge(FlowBuilderSupport.id(FlowBuilderSupport.generateId()), nodeDefinitions);
    }

    public FlowPathDefinition merge(Identifier id, FlowNodeDefinition<?> ... nodeDefinitions) {
        MergeDefinition mergeDefinition = (MergeDefinition)new MergeDefinition().id(id);
        this.definition.addNode(mergeDefinition);
        this.connectToNode(mergeDefinition, this.idList(nodeDefinitions));
        return new FlowPathDefinition(this.definition, mergeDefinition);
    }

    public FlowPathDefinition join(Identifier joinId, Identifier ... ids) {
        JoinDefinition joinDefinition = (JoinDefinition)new JoinDefinition().id(joinId);
        this.definition.addNode(joinDefinition);
        this.connectToNode(joinDefinition, Arrays.asList(ids));
        return new FlowPathDefinition(this.definition, joinDefinition);
    }

    public FlowPathDefinition join(FlowNodeDefinition<?> ... flowNodeDefinitions) {
        return this.join(FlowBuilderSupport.id(FlowBuilderSupport.generateId()), flowNodeDefinitions);
    }

    public FlowPathDefinition join(Identifier joinId, FlowNodeDefinition<?> ... flowNodeDefinitions) {
        JoinDefinition joinDefinition = (JoinDefinition)new JoinDefinition().id(joinId);
        this.definition.addNode(joinDefinition);
        this.connectToNode(joinDefinition, this.idList(flowNodeDefinitions));
        return new FlowPathDefinition(this.definition, joinDefinition);
    }

    List<Identifier> idList(FlowNodeDefinition<?> ... flowNodeDefinitions) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (FlowNodeDefinition<?> nodeDefinition : flowNodeDefinitions) {
            identifiers.add(nodeDefinition.getId());
        }
        return identifiers;
    }

    private void connectToNode(FlowNodeDefinition node, List<Identifier> idsToConnect) {
        for (Identifier id : idsToConnect) {
            this.definition.getNode(id).addOutgoing(node);
            this.definition.getNode(node.getId()).addIncoming(this.definition.getNode(id));
        }
    }

    public static TaskDefinition task(Identifier id) {
        return (TaskDefinition)((TaskDefinition)new TaskDefinition().id(id)).display(id.toString());
    }

    public static TaskDefinition task(Identifier id, Task callee) {
        return (TaskDefinition)((TaskDefinition)((TaskDefinition)new TaskDefinition().id(id)).display(id.toString())).call(new HandlerCallDefinition(callee));
    }

    public static EventDefinition event(Identifier id) {
        return (EventDefinition)((EventDefinition)new EventDefinition().id(id)).display(id.toString());
    }

    public static StringExpression expression(String expression) {
        return new StringExpression(expression);
    }

    public static <T> Value<T> constant(T value) {
        return new Value<T>(value);
    }

    public static Property<?> property(Identifier id) {
        return new Property(id);
    }

    public static <T> Property<T> property(Identifier id, Class<T> clazz) {
        return new Property(id);
    }

    public <T> T value(Identifier id, Class<T> clazz) {
        return this.value(new Property(id));
    }

    public <T> T value(Property property, Class<T> clazz) {
        return this.value(property);
    }

    public <T> T value(Property<T> property) {
        this.serviceCallInvocation.argument(property);
        return null;
    }

    public <T> T value(Value<T> value) {
        this.serviceCallInvocation.argument(value);
        return null;
    }

    public static EqualsExpression<Expression, Value<Object>> eq(Expression actual, Object expected) {
        return new ExpressionBuilder<Expression>(actual).isEqualTo(expected);
    }

    public static EqualsExpression<Expression, Value<Boolean>> isTrue(Expression actual) {
        return new ExpressionBuilder<Expression>(actual).isEqualTo(true);
    }

    public static <T extends Predicate> PredicateExpression<T> predicate(T predicate) {
        return new PredicateExpression<T>(predicate);
    }

    public static InvokeDefinition method(Class<?> clazz) {
        return new InvokeDefinition(clazz);
    }

    public CallDefinition method(Object returnValueOfProxyInvocation) {
        return this.serviceCallInvocation.createCallDefinitionFromCurrentStack();
    }

    public <T> T service(Class<T> clazz) {
        return this.serviceCallInvocation.createServiceProxy(clazz);
    }

    public static ExpressionBuilder<Value<CallDefinition>> resultOf(CallDefinition methodCall) {
        return new ExpressionBuilder<Value<CallDefinition>>(new Value<CallDefinition>(methodCall));
    }

    public static GoalDefinition goal(Identifier id) {
        return new GoalDefinition().id(id);
    }

    public static GoalDefinition goal() {
        return new GoalDefinition();
    }

    public static GoalDefinition check(PredicateExpression goalPredicate) {
        return new GoalDefinition().check(goalPredicate);
    }

    public static GoalDefinition check(Predicate<?> goalPredicate) {
        return FlowBuilderSupport.check(new PredicateExpression(goalPredicate));
    }
}

