/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.path;

import brainslug.flow.FlowDefinition;
import brainslug.flow.Identifier;
import brainslug.flow.node.ChoiceDefinition;
import brainslug.flow.node.EventDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.ParallelDefinition;
import brainslug.flow.node.marker.EndEvent;
import brainslug.flow.node.marker.IntermediateEvent;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.path.AndDefinition;
import java.util.LinkedList;

public class FlowPathDefinition<Self extends FlowPathDefinition> {
    protected final FlowDefinition definition;
    protected final FlowNodeDefinition startNode;
    LinkedList<FlowNodeDefinition> pathNodes = new LinkedList();

    public FlowPathDefinition(FlowDefinition definition, FlowNodeDefinition startNode) {
        this.definition = definition;
        this.startNode = startNode;
    }

    public ChoiceDefinition choice(Identifier id) {
        return (ChoiceDefinition)((ChoiceDefinition)this.appendNode(new ChoiceDefinition(this)).id(id)).self();
    }

    public AndDefinition parallel(Identifier id) {
        return ((ParallelDefinition)((ParallelDefinition)this.appendNode(new ParallelDefinition(this).id(id))).self()).fork();
    }

    public Self execute(AbstractTaskDefinition taskDefinition) {
        this.appendNode(taskDefinition);
        return this.then();
    }

    public Self waitFor(EventDefinition eventDefinition) {
        eventDefinition.with(new IntermediateEvent());
        this.appendNode(eventDefinition);
        return this.then();
    }

    public Self end(Identifier endId) {
        return this.end((FlowNodeDefinition<EventDefinition>)new EventDefinition().id(endId));
    }

    public Self end(FlowNodeDefinition<EventDefinition> eventDefinition) {
        if (this.definition.contains(eventDefinition)) {
            this.addToPath(eventDefinition);
            this.connect(this.pathNodes.getLast(), this.definition.getNode(eventDefinition.getId()));
            return this.then();
        }
        eventDefinition.with(new EndEvent());
        this.appendNode(eventDefinition);
        return this.then();
    }

    protected <T extends FlowNodeDefinition> T appendNode(T flowNodeDefinition) {
        if (this.definition.contains(flowNodeDefinition)) {
            throw new IllegalStateException("Node already exists");
        }
        if (this.pathNodes.isEmpty()) {
            this.connect(this.getStartNode(), flowNodeDefinition);
        } else {
            this.connect(this.getPathNodes().getLast(), flowNodeDefinition);
        }
        this.addToPath(flowNodeDefinition);
        this.definition.addNode(flowNodeDefinition);
        return flowNodeDefinition;
    }

    protected <T extends FlowNodeDefinition> void addToPath(T flowNodeDefinition) {
        this.pathNodes.add(flowNodeDefinition);
    }

    protected <T extends FlowNodeDefinition> void connect(FlowNodeDefinition previousNode, T flowNodeDefinition) {
        previousNode.addOutgoing(flowNodeDefinition);
        flowNodeDefinition.addIncoming(previousNode);
    }

    public Self then() {
        return (Self)this;
    }

    public LinkedList<FlowNodeDefinition> getPathNodes() {
        return this.pathNodes;
    }

    public FlowNodeDefinition getStartNode() {
        return this.startNode;
    }

    public FlowNodeDefinition getFirstNode() {
        return this.getPathNodes().peekFirst();
    }

    public FlowDefinition getDefinition() {
        return this.definition;
    }
}

