/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow;

import brainslug.flow.EnumIdentifier;
import brainslug.flow.FlowDefinition;
import brainslug.flow.Identifier;
import brainslug.flow.StringIdentifier;
import brainslug.flow.expression.Expression;
import brainslug.flow.expression.Predicate;
import brainslug.flow.expression.PredicateBuilder;
import brainslug.flow.expression.PredicateDefinition;
import brainslug.flow.expression.Property;
import brainslug.flow.node.EventDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.JoinDefinition;
import brainslug.flow.node.MergeDefinition;
import brainslug.flow.node.TaskDefinition;
import brainslug.flow.node.marker.StartEvent;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.node.task.CallDefinition;
import brainslug.flow.node.task.GoalDefinition;
import brainslug.flow.node.task.GoalPredicate;
import brainslug.flow.node.task.HandlerCallDefinition;
import brainslug.flow.node.task.ServiceCallDefinition;
import brainslug.flow.node.task.Task;
import brainslug.flow.path.FlowPathDefinition;
import java.util.Arrays;
import java.util.List;

public class FlowBuilderSupport {
    protected FlowDefinition definition;

    public FlowBuilderSupport withDefinition(FlowDefinition definition) {
        this.definition = definition;
        return this;
    }

    public Identifier id(Enum id) {
        return new EnumIdentifier(id);
    }

    public Identifier id(String id) {
        return new StringIdentifier(id);
    }

    public FlowPathDefinition start(Identifier startId) {
        return this.start(this.event(startId));
    }

    public FlowPathDefinition start(EventDefinition event) {
        event.with(new StartEvent());
        this.definition.addNode(event);
        return new FlowPathDefinition(this.definition, event);
    }

    public FlowPathDefinition start(AbstractTaskDefinition task) {
        this.definition.addNode(task);
        return new FlowPathDefinition(this.definition, task);
    }

    public FlowPathDefinition after(Identifier id) {
        return new FlowPathDefinition(this.definition, this.definition.getNode(id));
    }

    public FlowPathDefinition on(Identifier id) {
        return new FlowPathDefinition(this.definition, this.definition.getNode(id, EventDefinition.class));
    }

    public FlowPathDefinition merge(Identifier mergeId, Identifier ... ids) {
        MergeDefinition mergeDefinition = (MergeDefinition)new MergeDefinition().id(mergeId);
        this.definition.addNode(mergeDefinition);
        this.connectToNode(mergeDefinition, Arrays.asList(ids));
        return new FlowPathDefinition(this.definition, mergeDefinition);
    }

    public FlowPathDefinition join(Identifier joinId, Identifier ... ids) {
        JoinDefinition joinDefinition = (JoinDefinition)new JoinDefinition().id(joinId);
        this.definition.addNode(joinDefinition);
        this.connectToNode(joinDefinition, Arrays.asList(ids));
        return new FlowPathDefinition(this.definition, joinDefinition);
    }

    private void connectToNode(FlowNodeDefinition node, List<Identifier> idsToConnect) {
        for (Identifier id : idsToConnect) {
            this.definition.getNode(id).addOutgoing(node);
            this.definition.getNode(node.getId()).addIncoming(this.definition.getNode(id));
        }
    }

    public TaskDefinition task(Identifier id) {
        return (TaskDefinition)((TaskDefinition)new TaskDefinition().id(id)).display(id.toString());
    }

    public TaskDefinition task(Identifier id, Task callee) {
        return (TaskDefinition)((TaskDefinition)((TaskDefinition)new TaskDefinition().id(id)).display(id.toString())).call(new HandlerCallDefinition(callee));
    }

    public EventDefinition event(Identifier id) {
        return (EventDefinition)((EventDefinition)new EventDefinition().id(id)).display(id.toString());
    }

    public <T> PredicateBuilder<Expression> expression(T expression) {
        return new PredicateBuilder<Expression>(new Expression<T>(expression));
    }

    public <T> PredicateBuilder<Expression> constant(T expression) {
        return this.expression(expression);
    }

    public <T extends Identifier> PredicateBuilder<Property> property(T expression) {
        return new PredicateBuilder<Property>(new Property(expression));
    }

    public <T extends Predicate> PredicateDefinition<T> predicate(T predicate) {
        return new PredicateDefinition<T>(predicate);
    }

    public ServiceCallDefinition service(Class<?> clazz) {
        return new ServiceCallDefinition(clazz);
    }

    public HandlerCallDefinition run(Object callee) {
        return new HandlerCallDefinition(callee);
    }

    public PredicateBuilder<CallDefinition> resultOf(CallDefinition methodCall) {
        return new PredicateBuilder<CallDefinition>(methodCall);
    }

    public GoalDefinition goal(Identifier id) {
        return new GoalDefinition(this.definition).id(id);
    }

    public GoalDefinition check(Identifier id, GoalPredicate goalPredicate) {
        return new GoalDefinition(this.definition).id(id).check(goalPredicate);
    }
}

