/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.token;

import brainslug.flow.context.ExecutionContext;
import brainslug.flow.context.ExecutionContextFactory;
import brainslug.flow.context.Registry;
import brainslug.flow.context.Trigger;
import brainslug.flow.context.TriggerContext;
import brainslug.flow.definition.DefinitionStore;
import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.FlowExecutor;
import brainslug.flow.execution.async.AsyncTriggerScheduler;
import brainslug.flow.execution.async.AsyncTriggerStore;
import brainslug.flow.execution.expression.ExpressionEvaluator;
import brainslug.flow.execution.instance.InstanceSelector;
import brainslug.flow.execution.instance.InstanceStore;
import brainslug.flow.execution.node.ChoiceNodeExecutor;
import brainslug.flow.execution.node.DefaultNodeExecutor;
import brainslug.flow.execution.node.EventNodeExecutor;
import brainslug.flow.execution.node.FlowNodeExecutionResult;
import brainslug.flow.execution.node.FlowNodeExecutor;
import brainslug.flow.execution.node.JoinNodeExecutor;
import brainslug.flow.execution.node.TaskNodeExecutor;
import brainslug.flow.execution.node.task.CallDefinitionExecutor;
import brainslug.flow.execution.node.task.ScriptExecutor;
import brainslug.flow.execution.property.store.PropertyStore;
import brainslug.flow.execution.token.TokenOperations;
import brainslug.flow.execution.token.TokenStore;
import brainslug.flow.instance.FlowInstance;
import brainslug.flow.listener.EventType;
import brainslug.flow.listener.ListenerManager;
import brainslug.flow.node.ChoiceDefinition;
import brainslug.flow.node.EventDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.JoinDefinition;
import brainslug.flow.node.MergeDefinition;
import brainslug.flow.node.ParallelDefinition;
import brainslug.flow.node.TaskDefinition;
import brainslug.util.Option;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenFlowExecutor
implements FlowExecutor {
    private final ExecutionContextFactory executionContextFactory;
    private TokenOperations tokenOperations;
    private Logger log = LoggerFactory.getLogger(TokenFlowExecutor.class);
    protected TokenStore tokenStore;
    protected InstanceStore instanceStore;
    protected DefinitionStore definitionStore;
    protected PropertyStore propertyStore;
    protected ListenerManager listenerManager;
    protected Registry registry;
    protected ExpressionEvaluator expressionEvaluator;
    protected AsyncTriggerStore asyncTriggerStore;
    protected AsyncTriggerScheduler asyncTriggerScheduler;
    protected CallDefinitionExecutor callDefinitionExecutor;
    protected ScriptExecutor scriptExecutor;
    Map<Class<? extends FlowNodeDefinition>, FlowNodeExecutor> nodeExecutors = new HashMap<Class<? extends FlowNodeDefinition>, FlowNodeExecutor>();

    public TokenFlowExecutor(TokenStore tokenStore, InstanceStore instanceStore, DefinitionStore definitionStore, PropertyStore propertyStore, ListenerManager listenerManager, Registry registry, ExpressionEvaluator expressionEvaluator, AsyncTriggerStore asyncTriggerStore, AsyncTriggerScheduler asyncTriggerScheduler, CallDefinitionExecutor callDefinitionExecutor, ScriptExecutor scriptExecutor) {
        this.tokenStore = tokenStore;
        this.instanceStore = instanceStore;
        this.definitionStore = definitionStore;
        this.propertyStore = propertyStore;
        this.listenerManager = listenerManager;
        this.registry = registry;
        this.expressionEvaluator = expressionEvaluator;
        this.asyncTriggerStore = asyncTriggerStore;
        this.asyncTriggerScheduler = asyncTriggerScheduler;
        this.callDefinitionExecutor = callDefinitionExecutor;
        this.scriptExecutor = scriptExecutor;
        this.tokenOperations = new TokenOperations(tokenStore);
        this.executionContextFactory = new ExecutionContextFactory(propertyStore, registry);
        this.addNodeExecutorMappings();
    }

    protected void addNodeExecutorMappings() {
        this.nodeExecutors.put(EventDefinition.class, new EventNodeExecutor(this.asyncTriggerStore, this.expressionEvaluator));
        this.nodeExecutors.put(ParallelDefinition.class, new DefaultNodeExecutor());
        this.nodeExecutors.put(MergeDefinition.class, new DefaultNodeExecutor());
        this.nodeExecutors.put(ChoiceDefinition.class, new ChoiceNodeExecutor(this.expressionEvaluator));
        this.nodeExecutors.put(JoinDefinition.class, new JoinNodeExecutor());
        this.nodeExecutors.put(TaskDefinition.class, this.createTaskNodeExecutor());
    }

    protected TaskNodeExecutor createTaskNodeExecutor() {
        return new TaskNodeExecutor(this.definitionStore, this.expressionEvaluator, this.callDefinitionExecutor, this.asyncTriggerScheduler, this.scriptExecutor);
    }

    FlowNodeDefinition<?> getNode(Identifier definitionId, Identifier nodeId) {
        FlowNodeDefinition node = this.definitionStore.findById(definitionId).getNode(nodeId);
        if (node == null) {
            throw new IllegalArgumentException(String.format("node for does not exist %s", nodeId));
        }
        return node;
    }

    protected <T extends FlowNodeDefinition> FlowNodeExecutor<T> getNodeExecutor(T nodeDefinition) {
        FlowNodeExecutor nodeExecutor = this.nodeExecutors.get(nodeDefinition.getClass());
        if (nodeExecutor == null) {
            throw new IllegalArgumentException(String.format("no executor found for node definition %s", nodeDefinition));
        }
        return nodeExecutor;
    }

    @Override
    public FlowInstance startFlow(TriggerContext trigger) {
        FlowNodeDefinition<?> startNode = this.getStartNodeDefinition(trigger.getDefinitionId(), trigger.getNodeId());
        FlowInstance instance = this.instanceStore.createInstance(trigger.getDefinitionId());
        this.tokenStore.addToken(instance.getIdentifier(), startNode.getId(), (Option<Identifier>)Option.empty(), false);
        this.propertyStore.setProperties(instance.getIdentifier(), trigger.getProperties());
        this.trigger((TriggerContext)((Trigger)((Trigger)((Trigger)new Trigger().nodeId(startNode.getId())).definitionId(trigger.getDefinitionId())).instanceId(instance.getIdentifier())).properties(trigger.getProperties()));
        return (FlowInstance)this.instanceStore.findInstance(new InstanceSelector().withInstanceId(instance.getIdentifier())).get();
    }

    protected FlowNodeDefinition<?> getStartNodeDefinition(Identifier definitionId, Identifier nodeId) {
        return this.getNode(definitionId, nodeId);
    }

    @Override
    public void trigger(TriggerContext trigger) {
        this.log.debug("triggering {}", (Object)trigger);
        if (trigger.getInstanceId() == null) {
            throw new IllegalArgumentException("instance not specified for trigger");
        }
        FlowNodeDefinition<?> node = this.getNode(trigger.getDefinitionId(), trigger.getNodeId());
        FlowInstance flowInstance = (FlowInstance)this.instanceStore.findInstance(new InstanceSelector().withInstanceId(trigger.getInstanceId())).get();
        FlowNodeExecutor<FlowNodeDefinition<?>> nodeExecutor = this.getNodeExecutor(node);
        ExecutionContext executionContext = this.executionContextFactory.createExecutionContext(flowInstance, trigger);
        this.listenerManager.notifyListeners(EventType.BEFORE_EXECUTION, trigger);
        FlowNodeExecutionResult executionResult = nodeExecutor.execute(node, executionContext);
        this.propertyStore.setProperties(trigger.getInstanceId(), trigger.getProperties());
        this.listenerManager.notifyListeners(EventType.AFTER_EXECUTION, trigger);
        this.removeTokens(trigger, executionResult);
        this.triggerNext(trigger, node, executionResult);
    }

    private void removeTokens(TriggerContext trigger, FlowNodeExecutionResult executionResult) {
        for (FlowNodeExecutionResult.TokenRemoval removedToken : executionResult.getRemovedTokens()) {
            this.tokenOperations.removeTokens(trigger.getInstanceId(), removedToken.getNodeId(), removedToken.getSourceId(), removedToken.getQuantity());
        }
    }

    protected void triggerNext(TriggerContext trigger, FlowNodeDefinition<?> node, FlowNodeExecutionResult flowNodeExecutionResult) {
        for (FlowNodeDefinition nextNode : flowNodeExecutionResult.getNextNodes()) {
            this.addToken(trigger, node, nextNode);
            this.trigger(this.createTriggerContextForNextNode(trigger, nextNode));
        }
    }

    protected Trigger createTriggerContextForNextNode(TriggerContext event, FlowNodeDefinition nextNode) {
        return ((Trigger)((Trigger)((Trigger)new Trigger().nodeId(nextNode.getId())).definitionId(event.getDefinitionId())).instanceId(event.getInstanceId())).properties(event.getProperties());
    }

    protected void addToken(TriggerContext trigger, FlowNodeDefinition<?> node, FlowNodeDefinition nextNode) {
        this.tokenStore.addToken(trigger.getInstanceId(), nextNode.getId(), (Option<Identifier>)Option.of((Object)node.getId()), this.isFinalToken(nextNode));
    }

    private boolean isFinalToken(FlowNodeDefinition nextNode) {
        return nextNode.getOutgoing().isEmpty();
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setTokenOperations(TokenOperations tokenOperations) {
        this.tokenOperations = tokenOperations;
    }

    public void setDefinitionStore(DefinitionStore definitionStore) {
        this.definitionStore = definitionStore;
    }

    public void setPropertyStore(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
    }

    public void setListenerManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public void setAsyncTriggerStore(AsyncTriggerStore asyncTriggerStore) {
        this.asyncTriggerStore = asyncTriggerStore;
    }

    public void setAsyncTriggerScheduler(AsyncTriggerScheduler asyncTriggerScheduler) {
        this.asyncTriggerScheduler = asyncTriggerScheduler;
    }

    public void setCallDefinitionExecutor(CallDefinitionExecutor callDefinitionExecutor) {
        this.callDefinitionExecutor = callDefinitionExecutor;
    }
}

