/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.execution.async.AbstractRetryStrategy;
import brainslug.flow.execution.async.AsyncTrigger;
import brainslug.flow.execution.async.AsyncTriggerExecutionResult;
import brainslug.flow.execution.async.AsyncTriggerExecutor;
import brainslug.flow.execution.async.AsyncTriggerQuery;
import brainslug.flow.execution.async.AsyncTriggerSchedulerOptions;
import brainslug.flow.execution.async.AsyncTriggerStore;
import brainslug.flow.execution.async.ExecuteTaskCallable;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.TaskDefinition;
import brainslug.flow.node.task.RetryStrategy;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTasksCallable
implements Callable<List<Future<AsyncTriggerExecutionResult>>> {
    private AsyncTriggerExecutor asyncTriggerExecutor;
    private Logger log = LoggerFactory.getLogger(ExecuteTasksCallable.class);
    BrainslugContext context;
    AsyncTriggerSchedulerOptions options;
    AsyncTriggerStore asyncTriggerStore;
    ExecutorService taskExecutorService;

    ExecuteTasksCallable(BrainslugContext context, AsyncTriggerStore asyncTriggerStore, AsyncTriggerSchedulerOptions options, ExecutorService taskExecutorService, AsyncTriggerExecutor asyncTriggerExecutor) {
        this.context = context;
        this.asyncTriggerStore = asyncTriggerStore;
        this.options = options;
        this.taskExecutorService = taskExecutorService;
        this.asyncTriggerExecutor = asyncTriggerExecutor;
    }

    @Override
    public synchronized List<Future<AsyncTriggerExecutionResult>> call() {
        this.log.info("executing async triggers");
        try {
            List<ExecuteTaskCallable> tasksToBeExecuted = this.getTasksToBeExecuted();
            this.log.debug(String.format("scheduled %d trigger(s) for execution: %s", tasksToBeExecuted.size(), tasksToBeExecuted));
            return this.taskExecutorService.invokeAll(tasksToBeExecuted);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("task execution was interrupted", e);
            }
            this.log.error("unable to execute triggers", (Throwable)e);
            throw new RuntimeException("unable to execute triggers: ", e);
        }
    }

    protected List<ExecuteTaskCallable> getTasksToBeExecuted() {
        ArrayList<ExecuteTaskCallable> tasksToBeExecuted = new ArrayList<ExecuteTaskCallable>();
        for (AsyncTrigger trigger : this.getTasksToTrigger()) {
            FlowNodeDefinition nodeDefinition = this.context.getDefinitionById(trigger.getDefinitionId()).getNode(trigger.getNodeId(), FlowNodeDefinition.class);
            RetryStrategy retryStrategy = this.getRetryStrategy(nodeDefinition);
            tasksToBeExecuted.add(new ExecuteTaskCallable(this.context, trigger, this.asyncTriggerStore, this.asyncTriggerExecutor, retryStrategy));
        }
        return tasksToBeExecuted;
    }

    protected RetryStrategy getRetryStrategy(FlowNodeDefinition nodeDefinition) {
        if (nodeDefinition instanceof TaskDefinition) {
            return (RetryStrategy)((TaskDefinition)nodeDefinition).getRetryStrategy().orElse((Object)AbstractRetryStrategy.quadratic(30L, TimeUnit.SECONDS));
        }
        return AbstractRetryStrategy.linear(60L, TimeUnit.SECONDS);
    }

    protected List<AsyncTrigger> getTasksToTrigger() {
        return this.asyncTriggerStore.getTriggers(new AsyncTriggerQuery().withMaxCount(this.options.getMaxTaskCount()).withOverdueDate(new Date()));
    }
}

