/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.async.AsyncTrigger;
import brainslug.flow.execution.async.AsyncTriggerQuery;
import brainslug.flow.execution.async.AsyncTriggerStore;
import brainslug.util.Option;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ArrayListTriggerStore
implements AsyncTriggerStore {
    List<AsyncTrigger> triggers = new CopyOnWriteArrayList<AsyncTrigger>();

    @Override
    public AsyncTrigger storeTrigger(AsyncTrigger asyncTrigger) {
        if (this.triggers.contains(asyncTrigger)) {
            return asyncTrigger.incrementVersion();
        }
        this.triggers.add(asyncTrigger);
        return asyncTrigger;
    }

    @Override
    public AsyncTrigger updateTrigger(AsyncTrigger asyncTrigger) {
        if (this.triggers.contains(asyncTrigger)) {
            return asyncTrigger.incrementVersion();
        }
        throw new IllegalArgumentException("trigger cant  be updated because it does not exist: " + asyncTrigger);
    }

    @Override
    public boolean removeTrigger(AsyncTrigger asyncTrigger) {
        return this.triggers.remove(asyncTrigger);
    }

    @Override
    public List<AsyncTrigger> getTriggers(AsyncTriggerQuery triggerQuery) {
        Date dueDate = (Date)triggerQuery.getOverdueDate().orElse((Object)new Date());
        List<AsyncTrigger> overdueTriggers = this.getOverdueTriggers(dueDate);
        return overdueTriggers.subList(0, (int)Math.min(triggerQuery.maxCount, (long)overdueTriggers.size()));
    }

    protected List<AsyncTrigger> getOverdueTriggers(Date dueDate) {
        ArrayList<AsyncTrigger> overdueTasks = new ArrayList<AsyncTrigger>();
        for (AsyncTrigger task : this.triggers) {
            if (dueDate.getTime() < task.getDueDate()) continue;
            overdueTasks.add(task);
        }
        return overdueTasks;
    }

    @Override
    public Option<AsyncTrigger> getTrigger(Identifier taskNodeId, Identifier instanceId, Identifier definitionId) {
        for (AsyncTrigger trigger : this.triggers) {
            if (!trigger.getNodeId().equals(taskNodeId) || !trigger.getInstanceId().equals(instanceId) || !trigger.getDefinitionId().equals(definitionId)) continue;
            return Option.of((Object)trigger);
        }
        return Option.empty();
    }
}

