/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.context;

import brainslug.flow.context.ExecutionContext;
import brainslug.flow.context.Registry;
import brainslug.flow.context.TriggerContext;
import brainslug.flow.definition.Identifier;
import brainslug.flow.expression.Property;
import brainslug.flow.instance.FlowInstance;
import brainslug.flow.instance.FlowInstanceProperties;
import brainslug.flow.instance.FlowInstanceProperty;

public class BrainslugExecutionContext
implements ExecutionContext {
    Registry registry;
    private FlowInstance flowInstance;
    TriggerContext trigger;

    public BrainslugExecutionContext(FlowInstance flowInstance, TriggerContext trigger, Registry registry) {
        this.flowInstance = flowInstance;
        this.trigger = trigger;
        this.registry = registry;
    }

    public TriggerContext getTrigger() {
        return this.trigger;
    }

    public FlowInstance getInstance() {
        return this.flowInstance;
    }

    public boolean isAsync() {
        return this.trigger.isAsync();
    }

    public boolean isSignaling() {
        return this.trigger.isSignaling();
    }

    public void setProperty(String key, Object value) {
        this.trigger.setProperty(key, value);
    }

    public void setProperties(FlowInstanceProperties executionProperties) {
        this.trigger.setProperties(executionProperties);
    }

    public FlowInstanceProperties<?, FlowInstanceProperty<?>> getProperties() {
        return this.trigger.getProperties();
    }

    public <T> T property(Property<T> key, Class<T> clazz) {
        return this.property((Identifier)key.getValue(), clazz);
    }

    public <T> T property(Identifier key, Class<T> clazz) {
        return (T)this.getTrigger().getProperty(key.stringValue(), clazz);
    }

    public <T> T property(String key, Class<T> clazz) {
        return (T)this.getTrigger().getProperty(key, clazz);
    }

    public <T> T property(Enum key, Class<T> clazz) {
        return (T)this.getTrigger().getProperty(key.name(), clazz);
    }

    public <T> T service(Class<T> clazz) {
        return (T)this.registry.getService(clazz);
    }

    public Object service(String serviceName) {
        return this.registry.getService(serviceName);
    }
}

