/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.token;

import brainslug.flow.Identifier;
import brainslug.flow.context.BrainslugContext;
import brainslug.flow.execution.DefaultExecutionContext;
import brainslug.flow.execution.ExecutionContext;
import brainslug.flow.execution.ExecutionProperties;
import brainslug.flow.execution.FlowExecutor;
import brainslug.flow.execution.FlowNodeExecutionResult;
import brainslug.flow.execution.FlowNodeExecutor;
import brainslug.flow.execution.TriggerContext;
import brainslug.flow.execution.token.ChoiceNodeExecutor;
import brainslug.flow.execution.token.DefaultNodeExecutor;
import brainslug.flow.execution.token.EventNodeExecutor;
import brainslug.flow.execution.token.JoinNodeExecutor;
import brainslug.flow.execution.token.TaskNodeExecutor;
import brainslug.flow.execution.token.TokenStore;
import brainslug.flow.listener.EventType;
import brainslug.flow.node.ChoiceDefinition;
import brainslug.flow.node.EventDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.JoinDefinition;
import brainslug.flow.node.MergeDefinition;
import brainslug.flow.node.ParallelDefinition;
import brainslug.flow.node.TaskDefinition;
import brainslug.util.Option;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenFlowExecutor
implements FlowExecutor {
    private Logger log = LoggerFactory.getLogger(TokenFlowExecutor.class);
    protected BrainslugContext context;
    protected TokenStore tokenStore;
    Map<Class<? extends FlowNodeDefinition>, FlowNodeExecutor> nodeExecutors = new HashMap<Class<? extends FlowNodeDefinition>, FlowNodeExecutor>();

    public TokenFlowExecutor(BrainslugContext brainslugContext) {
        this.context = brainslugContext;
        this.tokenStore = this.context.getTokenStore();
        this.addNodeExecutorMappings();
    }

    protected void addNodeExecutorMappings() {
        this.nodeExecutors.put(EventDefinition.class, new EventNodeExecutor().withTokenStore(this.tokenStore));
        this.nodeExecutors.put(ParallelDefinition.class, new DefaultNodeExecutor().withTokenStore(this.tokenStore));
        this.nodeExecutors.put(MergeDefinition.class, new DefaultNodeExecutor().withTokenStore(this.tokenStore));
        this.nodeExecutors.put(ChoiceDefinition.class, new ChoiceNodeExecutor().withTokenStore(this.tokenStore));
        this.nodeExecutors.put(JoinDefinition.class, new JoinNodeExecutor().withTokenStore(this.tokenStore));
        this.nodeExecutors.put(TaskDefinition.class, new TaskNodeExecutor().withTokenStore(this.tokenStore));
    }

    FlowNodeDefinition<?> getNode(Identifier definitionId, Identifier nodeId) {
        FlowNodeDefinition node = this.context.getDefinitionStore().findById(definitionId).getNode(nodeId);
        if (node == null) {
            throw new IllegalArgumentException(String.format("node for does not exist %s", nodeId));
        }
        return node;
    }

    protected <T extends FlowNodeDefinition> FlowNodeExecutor<T> getNodeExecutor(T nodeDefinition) {
        FlowNodeExecutor nodeExecutor = this.nodeExecutors.get(nodeDefinition.getClass());
        if (nodeExecutor == null) {
            throw new IllegalArgumentException(String.format("no executor found for node definition %s", nodeDefinition));
        }
        return nodeExecutor;
    }

    @Override
    public Identifier startFlow(TriggerContext<?> trigger) {
        FlowNodeDefinition<?> startNode = this.getStartNodeDefinition(trigger.getDefinitionId(), trigger.getNodeId());
        Identifier instanceId = this.tokenStore.createInstance(trigger.getDefinitionId());
        this.tokenStore.addToken(instanceId, startNode.getId(), (Option<Identifier>)Option.empty());
        this.context.getPropertyStore().storeProperties(trigger.getInstanceId(), trigger.getProperties());
        this.context.trigger((TriggerContext)((TriggerContext)((TriggerContext)((TriggerContext)new TriggerContext().nodeId(startNode.getId())).definitionId(trigger.getDefinitionId())).instanceId(instanceId)).properties(trigger.getProperties()));
        return instanceId;
    }

    protected FlowNodeDefinition<?> getStartNodeDefinition(Identifier definitionId, Identifier nodeId) {
        return this.getNode(definitionId, nodeId);
    }

    @Override
    public void trigger(TriggerContext<?> triggerContext) {
        this.log.debug("triggering {}", triggerContext);
        FlowNodeDefinition<?> node = this.getNode(triggerContext.getDefinitionId(), triggerContext.getNodeId());
        FlowNodeExecutor<FlowNodeDefinition<?>> nodeExecutor = this.getNodeExecutor(node);
        ExecutionContext executionContext = this.createExecutionContext(triggerContext);
        this.context.getListenerManager().notifyListeners(EventType.BEFORE_EXECUTION, triggerContext);
        FlowNodeExecutionResult executionResult = nodeExecutor.execute(node, executionContext);
        this.context.getPropertyStore().storeProperties(triggerContext.getInstanceId(), triggerContext.getProperties());
        this.context.getListenerManager().notifyListeners(EventType.AFTER_EXECUTION, triggerContext);
        this.triggerNext(triggerContext, node, executionResult);
    }

    protected ExecutionContext createExecutionContext(TriggerContext triggerContext) {
        DefaultExecutionContext executionContext = new DefaultExecutionContext(triggerContext, this.context);
        if (triggerContext.getInstanceId() != null) {
            executionContext.getTrigger().properties(this.mergeProperties(triggerContext, executionContext));
        }
        return executionContext;
    }

    protected ExecutionProperties mergeProperties(TriggerContext triggerContext, DefaultExecutionContext executionContext) {
        ExecutionProperties properties = this.context.getPropertyStore().loadProperties(executionContext.getTrigger().getInstanceId());
        properties.putAll(triggerContext.getProperties());
        return properties;
    }

    protected void triggerNext(TriggerContext triggerContext, FlowNodeDefinition<?> node, FlowNodeExecutionResult flowNodeExecutionResult) {
        for (FlowNodeDefinition nextNode : flowNodeExecutionResult.getNextNodes()) {
            this.addToken(triggerContext, node, nextNode);
            this.trigger(this.createTriggerContextForNextNode(triggerContext, nextNode));
        }
    }

    protected TriggerContext createTriggerContextForNextNode(TriggerContext<?> event, FlowNodeDefinition nextNode) {
        return ((TriggerContext)((TriggerContext)((TriggerContext)new TriggerContext().nodeId(nextNode.getId())).definitionId(event.getDefinitionId())).instanceId(event.getInstanceId())).properties(event.getProperties());
    }

    protected void addToken(TriggerContext triggerContext, FlowNodeDefinition<?> node, FlowNodeDefinition nextNode) {
        if (triggerContext.getInstanceId() != null) {
            this.tokenStore.addToken(triggerContext.getInstanceId(), nextNode.getId(), (Option<Identifier>)Option.of((Object)node.getId()));
        }
    }
}

