/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.token;

import brainslug.flow.FlowDefinition;
import brainslug.flow.Identifier;
import brainslug.flow.execution.Execute;
import brainslug.flow.execution.ExecutionContext;
import brainslug.flow.execution.FlowNodeExecutionResult;
import brainslug.flow.execution.GoalCondition;
import brainslug.flow.execution.SimpleTask;
import brainslug.flow.execution.async.AsyncTask;
import brainslug.flow.execution.token.DefaultNodeExecutor;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.node.task.HandlerCallDefinition;
import brainslug.flow.node.task.ServiceCallDefinition;
import brainslug.flow.node.task.Task;
import brainslug.util.Option;
import brainslug.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskNodeExecutor
extends DefaultNodeExecutor<AbstractTaskDefinition> {
    private Logger log = LoggerFactory.getLogger(TaskNodeExecutor.class);

    @Override
    public FlowNodeExecutionResult execute(AbstractTaskDefinition taskDefinition, ExecutionContext execution) {
        this.consumeAllNodeTokens(execution.getTrigger().getInstanceId(), execution.getTrigger().getNodeId());
        if (taskDefinition.getGoal().isPresent() && this.goalIsFulfilled((Identifier)taskDefinition.getGoal().get(), execution)) {
            return this.takeAll((FlowNodeDefinition<?>)taskDefinition);
        }
        if (taskDefinition.isAsync() && !execution.getTrigger().isAsync().booleanValue()) {
            this.scheduleAsyncTask(taskDefinition, execution);
            return this.takeNone();
        }
        if (taskDefinition.getDelegateClass() != null) {
            Object delegateInstance = execution.getBrainslugContext().getRegistry().getService(taskDefinition.getDelegateClass());
            this.executeDelegate(delegateInstance, execution);
            return this.takeAll((FlowNodeDefinition<?>)taskDefinition);
        }
        if (taskDefinition.getMethodCall() instanceof HandlerCallDefinition) {
            Object callee = ((HandlerCallDefinition)taskDefinition.getMethodCall()).getCallee();
            this.executeDelegate(callee, execution);
            return this.takeAll((FlowNodeDefinition<?>)taskDefinition);
        }
        if (taskDefinition.getMethodCall() instanceof ServiceCallDefinition) {
            this.executeServiceMethodCall(taskDefinition, (ServiceCallDefinition)taskDefinition.getMethodCall(), execution);
            return this.takeAll((FlowNodeDefinition<?>)taskDefinition);
        }
        this.log.warn("executing task node without execution definition, please specify the task node execution by using a delegate class or call definition to actually do something in this task");
        return this.takeAll((FlowNodeDefinition<?>)taskDefinition);
    }

    protected boolean goalIsFulfilled(Identifier goalId, ExecutionContext execution) {
        FlowDefinition definition = execution.getBrainslugContext().getDefinitionStore().findById(execution.getTrigger().getDefinitionId());
        Option goalPredicate = definition.getGoalPredicate(goalId);
        if (!goalPredicate.isPresent()) {
            return false;
        }
        if (goalPredicate.get() instanceof GoalCondition) {
            GoalCondition goalCondition = (GoalCondition)goalPredicate.get();
            return goalCondition.isFulfilled(execution);
        }
        throw new IllegalArgumentException("goal predicate type not supported: " + goalPredicate.getClass().getName());
    }

    protected void scheduleAsyncTask(AbstractTaskDefinition taskDefinition, ExecutionContext execution) {
        execution.getBrainslugContext().getAsyncTaskScheduler().scheduleTask(new AsyncTask().withTaskNodeId(taskDefinition.getId()).withInstanceId(execution.getTrigger().getInstanceId()).withDefinitionId(execution.getTrigger().getDefinitionId()));
    }

    protected void executeServiceMethodCall(AbstractTaskDefinition taskDefinition, ServiceCallDefinition serviceCall, ExecutionContext context) {
        Class serviceClass = serviceCall.getServiceClass();
        Object serviceInstance = context.getBrainslugContext().getRegistry().getService(serviceClass);
        this.invokeServiceMethodWithArguments(taskDefinition, serviceClass, serviceCall.getMethodName(), serviceInstance);
    }

    protected void invokeServiceMethodWithArguments(AbstractTaskDefinition taskDefinition, Class<?> serviceClass, String methodName, Object serviceInstance) {
        try {
            Method serviceMethod = serviceClass.getMethod(methodName, new Class[0]);
            serviceMethod.invoke(serviceInstance, taskDefinition.getMethodCall().getArguments().toArray());
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected void executeDelegate(Object delegateInstance, ExecutionContext context) {
        if (delegateInstance instanceof SimpleTask) {
            ((SimpleTask)delegateInstance).execute(context);
        } else if (delegateInstance instanceof Task) {
            Method executeMethod = ReflectionUtil.getFirstMethodAnnotatedWith(delegateInstance.getClass(), Execute.class);
            this.invokeServiceMethodWithContext(context, delegateInstance, executeMethod);
        } else {
            throw new IllegalArgumentException(this.unsupportedDelegateMessage(delegateInstance));
        }
    }

    protected String unsupportedDelegateMessage(Object delegateInstance) {
        return "unsupported delegate class: " + delegateInstance.getClass() + " use " + Task.class.getName() + " or " + SimpleTask.class.getName();
    }

    protected void invokeServiceMethodWithContext(ExecutionContext context, Object serviceInstance, Method executeMethod) {
        try {
            executeMethod.setAccessible(true);
            executeMethod.invoke(serviceInstance, this.executionArguments(context, executeMethod).toArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Object> executionArguments(ExecutionContext context, Method executeMethod) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (Class<ExecutionContext> clazz : executeMethod.getParameterTypes()) {
            if (clazz.isAssignableFrom(ExecutionContext.class)) {
                arguments.add(context);
                continue;
            }
            arguments.add(context.getBrainslugContext().getRegistry().getService(clazz));
        }
        return arguments;
    }
}

